/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.compiler;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.Keywords;
import org.apache.xpath.compiler.Lexer;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class XPathParser {
    private OpMap m_ops;
    transient String m_token;
    transient char m_tokenChar = '\u0000';
    int m_queueMark = 0;
    PrefixResolver m_namespaceContext;
    private ErrorListener m_errorListener;
    SourceLocator m_sourceLocator;

    public XPathParser(ErrorListener errorListener, SourceLocator sourceLocator) {
        this.m_errorListener = errorListener;
        this.m_sourceLocator = sourceLocator;
    }

    protected void AbbreviatedNodeTestStep() throws TransformerException {
        int n;
        int n2 = this.m_ops.m_opMap[1];
        int n3 = -1;
        if (this.tokenIs('@')) {
            n = 51;
            this.appendOp(2, n);
            this.nextToken();
        } else if (this.lookahead("::", 1)) {
            if (this.tokenIs("attribute")) {
                n = 51;
                this.appendOp(2, n);
            } else if (this.tokenIs("child")) {
                n = 53;
                this.appendOp(2, n);
            } else {
                n = -1;
                this.error(44, new Object[]{this.m_token});
            }
            this.nextToken();
            this.nextToken();
        } else if (this.tokenIs('/')) {
            n = 52;
            this.appendOp(2, n);
            this.nextToken();
        } else {
            if (this.tokenIs('/')) {
                this.nextToken();
            }
            n3 = this.m_ops.m_opMap[1];
            n = 53;
            this.appendOp(2, n);
        }
        this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        this.NodeTest(n);
        this.m_ops.m_opMap[n2 + 1 + 1] = this.m_ops.m_opMap[1] - n2;
        while (this.tokenIs('[')) {
            this.Predicate();
        }
        if (n3 > -1 && this.tokenIs('/') && this.lookahead('/', 1)) {
            this.m_ops.m_opMap[n3] = 52;
            this.nextToken();
        }
        this.m_ops.m_opMap[n2 + 1] = this.m_ops.m_opMap[1] - n2;
    }

    protected int AdditiveExpr(int n) throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        if (n == -1) {
            n = n2;
        }
        this.MultiplicativeExpr(-1);
        if (this.m_token != null) {
            if (this.tokenIs('+')) {
                this.nextToken();
                this.insertOp(n, 2, 10);
                int n3 = this.m_ops.m_opMap[1] - n;
                n = this.AdditiveExpr(n);
                this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[n + n3 + 1] + n3;
                n += 2;
            } else if (this.tokenIs('-')) {
                this.nextToken();
                this.insertOp(n, 2, 11);
                int n4 = this.m_ops.m_opMap[1] - n;
                n = this.AdditiveExpr(n);
                this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[n + n4 + 1] + n4;
                n += 2;
            }
        }
        return n;
    }

    protected void AndExpr() throws TransformerException {
        int n = this.m_ops.m_opMap[1];
        this.EqualityExpr(-1);
        if (this.m_token != null && this.tokenIs("and")) {
            this.nextToken();
            this.insertOp(n, 2, 3);
            this.AndExpr();
            this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[1] - n;
        }
    }

    protected void Argument() throws TransformerException {
        int n = this.m_ops.m_opMap[1];
        this.appendOp(2, 26);
        this.Expr();
        this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[1] - n;
    }

    protected int AxisName() throws TransformerException {
        Object v = Keywords.m_axisnames.get(this.m_token);
        if (v == null) {
            this.error(35, new Object[]{this.m_token});
        }
        int n = (Integer)v;
        this.appendOp(2, n);
        return n;
    }

    protected void Basis() throws TransformerException {
        int n;
        int n2 = this.m_ops.m_opMap[1];
        if (this.lookahead("::", 1)) {
            n = this.AxisName();
            this.nextToken();
            this.nextToken();
        } else if (this.tokenIs('@')) {
            n = 39;
            this.appendOp(2, n);
            this.nextToken();
        } else {
            if (this.tokenIs('/')) {
                int n3 = 42;
                this.appendOp(2, n3);
                this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
                this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = 1033;
                this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
                this.m_ops.m_opMap[n2 + 1 + 1] = this.m_ops.m_opMap[1] - n2;
                return;
            }
            n = 40;
            this.appendOp(2, n);
        }
        this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        this.NodeTest(n);
        this.m_ops.m_opMap[n2 + 1 + 1] = this.m_ops.m_opMap[1] - n2;
    }

    protected void BooleanExpr() throws TransformerException {
        int n = this.m_ops.m_opMap[1];
        this.appendOp(2, 18);
        this.Expr();
        int n2 = this.m_ops.m_opMap[1] - n;
        if (n2 == 2) {
            this.error(31, null);
        }
        this.m_ops.m_opMap[n + 1] = n2;
    }

    protected int EqualityExpr(int n) throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        if (n == -1) {
            n = n2;
        }
        this.RelationalExpr(-1);
        if (this.m_token != null) {
            if (this.tokenIs('!') && this.lookahead('=', 1)) {
                this.nextToken();
                this.nextToken();
                this.insertOp(n, 2, 4);
                int n3 = this.m_ops.m_opMap[1] - n;
                n = this.EqualityExpr(n);
                this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[n + n3 + 1] + n3;
                n += 2;
            } else if (this.tokenIs('=')) {
                this.nextToken();
                this.insertOp(n, 2, 5);
                int n4 = this.m_ops.m_opMap[1] - n;
                n = this.EqualityExpr(n);
                this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[n + n4 + 1] + n4;
                n += 2;
            }
        }
        return n;
    }

    protected void Expr() throws TransformerException {
        this.OrExpr();
    }

    protected void FilterExpr() throws TransformerException {
        int n = this.m_ops.m_opMap[1];
        this.PrimaryExpr();
        if (this.tokenIs('[')) {
            this.insertOp(n, 2, 28);
            while (this.tokenIs('[')) {
                this.Predicate();
            }
            if (this.tokenIs('/')) {
                this.nextToken();
                this.RelativeLocationPath();
            }
            this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -1;
            this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
            this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[1] - n;
        }
    }

    protected void FunctionCall() throws TransformerException {
        int n = this.m_ops.m_opMap[1];
        if (this.lookahead(':', 1)) {
            this.appendOp(4, 24);
            this.m_ops.m_opMap[n + 1 + 1] = this.m_queueMark - 1;
            this.nextToken();
            this.consumeExpected(':');
            this.m_ops.m_opMap[n + 1 + 2] = this.m_queueMark - 1;
            this.nextToken();
        } else {
            int n2 = this.getFunctionToken(this.m_token);
            if (n2 == -1) {
                this.error(47, new Object[]{this.m_token});
            }
            switch (n2) {
                case 1030: 
                case 1031: 
                case 1032: 
                case 1033: {
                    this.LocationPath();
                    return;
                }
            }
            this.appendOp(3, 25);
            this.m_ops.m_opMap[n + 1 + 1] = n2;
            this.nextToken();
        }
        this.consumeExpected('(');
        while (!this.tokenIs(')') && this.m_token != null) {
            if (this.tokenIs(',')) {
                this.error(32, null);
            }
            this.Argument();
            if (this.tokenIs(')')) continue;
            this.consumeExpected(',');
            if (!this.tokenIs(')')) continue;
            this.error(33, null);
        }
        this.consumeExpected(')');
        this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -1;
        this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[1] - n;
    }

    protected void IdKeyPattern() throws TransformerException {
        this.FunctionCall();
    }

    protected void Literal() throws TransformerException {
        int n = this.m_token.length() - 1;
        char c = this.m_tokenChar;
        char c2 = this.m_token.charAt(n);
        if (c == '\"' && c2 == '\"' || c == '\'' && c2 == '\'') {
            int n2 = this.m_queueMark - 1;
            this.m_ops.m_tokenQueue[n2] = null;
            XString xString = new XString(this.m_token.substring(1, n));
            this.m_ops.m_tokenQueue[n2] = xString;
            this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = n2;
            this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
            this.nextToken();
        } else {
            this.error(37, new Object[]{this.m_token});
        }
    }

    protected void LocationPath() throws TransformerException {
        int n = this.m_ops.m_opMap[1];
        this.appendOp(2, 28);
        if (this.tokenIs('/')) {
            this.appendOp(4, 50);
            this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 2] = 4;
            this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 1] = 35;
            this.nextToken();
        }
        if (this.m_token != null) {
            this.RelativeLocationPath();
        }
        this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -1;
        this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[1] - n;
    }

    protected void LocationPathPattern() throws TransformerException {
        int n = this.m_ops.m_opMap[1];
        this.appendOp(2, 31);
        if (this.lookahead('(', 1) && (this.tokenIs("id") || this.tokenIs("key"))) {
            this.IdKeyPattern();
            if (this.tokenIs('/') && this.lookahead('/', 1)) {
                this.appendOp(4, 52);
                this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 2] = 4;
                this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 1] = 1034;
                this.nextToken();
                this.nextToken();
            }
        } else if (this.tokenIs('/')) {
            if (this.lookahead('/', 1)) {
                this.appendOp(4, 52);
            } else {
                this.appendOp(4, 50);
            }
            this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 2] = 4;
            this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 1] = 35;
            this.nextToken();
        }
        if (!this.tokenIs('|') && this.m_token != null) {
            this.RelativePathPattern();
        }
        this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -1;
        this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[1] - n;
    }

    protected int MultiplicativeExpr(int n) throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        if (n == -1) {
            n = n2;
        }
        this.UnaryExpr();
        if (this.m_token != null) {
            if (this.tokenIs('*')) {
                this.nextToken();
                this.insertOp(n, 2, 12);
                int n3 = this.m_ops.m_opMap[1] - n;
                n = this.MultiplicativeExpr(n);
                this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[n + n3 + 1] + n3;
                n += 2;
            } else if (this.tokenIs("div")) {
                this.nextToken();
                this.insertOp(n, 2, 13);
                int n4 = this.m_ops.m_opMap[1] - n;
                n = this.MultiplicativeExpr(n);
                this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[n + n4 + 1] + n4;
                n += 2;
            } else if (this.tokenIs("mod")) {
                this.nextToken();
                this.insertOp(n, 2, 14);
                int n5 = this.m_ops.m_opMap[1] - n;
                n = this.MultiplicativeExpr(n);
                this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[n + n5 + 1] + n5;
                n += 2;
            } else if (this.tokenIs("quo")) {
                this.nextToken();
                this.insertOp(n, 2, 15);
                int n6 = this.m_ops.m_opMap[1] - n;
                n = this.MultiplicativeExpr(n);
                this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[n + n6 + 1] + n6;
                n += 2;
            }
        }
        return n;
    }

    protected void NCName() {
        this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = this.m_queueMark - 1;
        this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        this.nextToken();
    }

    protected void NodeTest(int n) throws TransformerException {
        if (this.lookahead('(', 1)) {
            Object v = Keywords.m_nodetypes.get(this.m_token);
            if (v == null) {
                this.error(36, new Object[]{this.m_token});
            } else {
                int n2;
                this.nextToken();
                this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = n2 = ((Integer)v).intValue();
                this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
                this.consumeExpected('(');
                if (n2 == 1032 && !this.tokenIs(')')) {
                    this.Literal();
                }
                this.consumeExpected(')');
            }
        } else {
            this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = 34;
            this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
            if (this.lookahead(':', 1)) {
                this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = this.tokenIs('*') ? -3 : this.m_queueMark - 1;
                this.nextToken();
                this.consumeExpected(':');
            } else {
                this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -2;
            }
            this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
            if (this.tokenIs('*')) {
                this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -3;
            } else {
                if (n == 49) {
                    String string = (String)this.m_ops.m_tokenQueue[this.m_queueMark - 1];
                    String string2 = this.m_namespaceContext.getNamespaceForPrefix(string);
                    this.m_ops.m_tokenQueue[this.m_queueMark - 1] = string2;
                }
                this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = this.m_queueMark - 1;
            }
            this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
            this.nextToken();
        }
    }

    protected void Number() throws TransformerException {
        if (this.m_token != null) {
            double d;
            try {
                d = Double.valueOf(this.m_token);
            }
            catch (NumberFormatException numberFormatException) {
                d = 0.0;
                this.error(38, new Object[]{this.m_token});
            }
            this.m_ops.m_tokenQueue[this.m_queueMark - 1] = new XNumber(d);
            this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = this.m_queueMark - 1;
            this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
            this.nextToken();
        }
    }

    protected void NumberExpr() throws TransformerException {
        int n = this.m_ops.m_opMap[1];
        this.appendOp(2, 19);
        this.Expr();
        this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[1] - n;
    }

    protected void OrExpr() throws TransformerException {
        int n = this.m_ops.m_opMap[1];
        this.AndExpr();
        if (this.m_token != null && this.tokenIs("or")) {
            this.nextToken();
            this.insertOp(n, 2, 2);
            this.OrExpr();
            this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[1] - n;
        }
    }

    protected void PathExpr() throws TransformerException {
        int n = this.m_ops.m_opMap[1];
        this.FilterExpr();
        if (this.tokenIs('/')) {
            this.nextToken();
            this.insertOp(n, 2, 28);
            this.RelativeLocationPath();
            this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -1;
            this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
            this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[1] - n;
        }
    }

    protected void Pattern() throws TransformerException {
        while (true) {
            this.LocationPathPattern();
            if (!this.tokenIs('|')) break;
            this.nextToken();
        }
    }

    protected void Predicate() throws TransformerException {
        if (this.tokenIs('[')) {
            this.nextToken();
            this.PredicateExpr();
            this.consumeExpected(']');
        }
    }

    protected void PredicateExpr() throws TransformerException {
        int n = this.m_ops.m_opMap[1];
        this.appendOp(2, 29);
        this.Expr();
        this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -1;
        this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[1] - n;
    }

    protected void PrimaryExpr() throws TransformerException {
        int n = this.m_ops.m_opMap[1];
        if (this.m_tokenChar == '\'' || this.m_tokenChar == '\"') {
            this.appendOp(2, 21);
            this.Literal();
            this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[1] - n;
        } else if (this.m_tokenChar == '$') {
            this.nextToken();
            this.appendOp(2, 22);
            this.QName();
            this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[1] - n;
        } else if (this.m_tokenChar == '(') {
            this.nextToken();
            this.appendOp(2, 23);
            this.Expr();
            this.consumeExpected(')');
            this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[1] - n;
        } else if (this.m_token != null && (this.m_tokenChar == '.' && this.m_token.length() > 1 && Character.isDigit(this.m_token.charAt(1)) || Character.isDigit(this.m_tokenChar))) {
            this.appendOp(2, 27);
            this.Number();
            this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[1] - n;
        } else if (this.lookahead('(', 1) || this.lookahead(':', 1) && this.lookahead('(', 3)) {
            this.FunctionCall();
        } else {
            this.LocationPath();
        }
    }

    protected void QName() throws TransformerException {
        if (this.lookahead(':', 1)) {
            this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = this.m_queueMark - 1;
            this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
            this.nextToken();
            this.consumeExpected(':');
        } else {
            this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -2;
            this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        }
        this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = this.m_queueMark - 1;
        this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        this.nextToken();
    }

    protected int RelationalExpr(int n) throws TransformerException {
        int n2 = this.m_ops.m_opMap[1];
        if (n == -1) {
            n = n2;
        }
        this.AdditiveExpr(-1);
        if (this.m_token != null) {
            if (this.tokenIs('<')) {
                this.nextToken();
                if (this.tokenIs('=')) {
                    this.nextToken();
                    this.insertOp(n, 2, 6);
                } else {
                    this.insertOp(n, 2, 7);
                }
                int n3 = this.m_ops.m_opMap[1] - n;
                n = this.RelationalExpr(n);
                this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[n + n3 + 1] + n3;
                n += 2;
            } else if (this.tokenIs('>')) {
                this.nextToken();
                if (this.tokenIs('=')) {
                    this.nextToken();
                    this.insertOp(n, 2, 8);
                } else {
                    this.insertOp(n, 2, 9);
                }
                int n4 = this.m_ops.m_opMap[1] - n;
                n = this.RelationalExpr(n);
                this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[n + n4 + 1] + n4;
                n += 2;
            }
        }
        return n;
    }

    protected void RelativeLocationPath() throws TransformerException {
        this.Step();
        while (this.tokenIs('/')) {
            this.nextToken();
            this.Step();
        }
    }

    protected void RelativePathPattern() throws TransformerException {
        this.StepPattern();
        while (this.tokenIs('/')) {
            this.nextToken();
            this.StepPattern();
        }
    }

    protected void Step() throws TransformerException {
        int n = this.m_ops.m_opMap[1];
        if (this.tokenIs(".")) {
            this.nextToken();
            if (this.tokenIs('[')) {
                this.error(34, null);
            }
            this.appendOp(4, 48);
            this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 2] = 4;
            this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 1] = 1033;
        } else if (this.tokenIs("..")) {
            this.nextToken();
            this.appendOp(4, 45);
            this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 2] = 4;
            this.m_ops.m_opMap[this.m_ops.m_opMap[1] - 1] = 1033;
        } else if (this.tokenIs('*') || this.tokenIs('@') || this.tokenIs('/') || this.tokenIs('_') || this.m_token != null && Character.isLetter(this.m_token.charAt(0))) {
            this.Basis();
            while (this.tokenIs('[')) {
                this.Predicate();
            }
            this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[1] - n;
        }
    }

    protected void StepPattern() throws TransformerException {
        this.AbbreviatedNodeTestStep();
    }

    protected void StringExpr() throws TransformerException {
        int n = this.m_ops.m_opMap[1];
        this.appendOp(2, 17);
        this.Expr();
        this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[1] - n;
    }

    protected void UnaryExpr() throws TransformerException {
        int n = this.m_ops.m_opMap[1];
        boolean bl = false;
        if (this.m_tokenChar == '-') {
            this.nextToken();
            this.appendOp(2, 16);
            bl = true;
        }
        this.UnionExpr();
        if (bl) {
            this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[1] - n;
        }
    }

    protected void UnionExpr() throws TransformerException {
        int n = this.m_ops.m_opMap[1];
        boolean bl = true;
        boolean bl2 = false;
        do {
            this.PathExpr();
            if (!this.tokenIs('|')) break;
            if (!bl2) {
                bl2 = true;
                this.insertOp(n, 2, 20);
            }
            this.nextToken();
        } while (bl);
        this.m_ops.m_opMap[n + 1] = this.m_ops.m_opMap[1] - n;
    }

    void appendOp(int n, int n2) {
        int n3 = this.m_ops.m_opMap[1];
        this.m_ops.m_opMap[n3] = n2;
        this.m_ops.m_opMap[n3 + 1] = n;
        this.m_ops.m_opMap[1] = n3 + n;
    }

    private void assert(boolean bl, String string) {
        if (!bl) {
            String string2 = XSLMessages.createXPATHMessage(30, new Object[]{string});
            throw new RuntimeException(string2);
        }
    }

    private final void consumeExpected(char c) throws TransformerException {
        if (this.tokenIs(c)) {
            this.nextToken();
        } else {
            this.error(29, new Object[]{String.valueOf(c), this.m_token});
        }
    }

    private final void consumeExpected(String string) throws TransformerException {
        if (this.tokenIs(string)) {
            this.nextToken();
        } else {
            this.error(29, new Object[]{string, this.m_token});
        }
    }

    protected String dumpRemainingTokenQueue() {
        String string;
        int n = this.m_queueMark;
        if (n < this.m_ops.m_tokenQueueSize) {
            String string2 = "\n Remaining tokens: (";
            while (n < this.m_ops.m_tokenQueueSize) {
                String string3 = (String)this.m_ops.m_tokenQueue[n++];
                string2 = String.valueOf(string2) + " '" + string3 + "'";
            }
            string = String.valueOf(string2) + ")";
        } else {
            string = "";
        }
        return string;
    }

    void error(int n, Object[] objectArray) throws TransformerException {
        String string = XSLMessages.createXPATHMessage(n, objectArray);
        ErrorListener errorListener = this.getErrorListener();
        TransformerException transformerException = new TransformerException(string, this.m_sourceLocator);
        if (errorListener == null) {
            throw transformerException;
        }
        errorListener.fatalError(transformerException);
    }

    public ErrorListener getErrorListener() {
        return this.m_errorListener;
    }

    final int getFunctionToken(String string) {
        int n;
        try {
            n = (Integer)Keywords.m_functions.get(string);
        }
        catch (NullPointerException nullPointerException) {
            n = -1;
        }
        catch (ClassCastException classCastException) {
            n = -1;
        }
        return n;
    }

    private final String getTokenRelative(int n) {
        int n2 = this.m_queueMark + n;
        String string = n2 > 0 && n2 < this.m_ops.m_tokenQueueSize ? (String)this.m_ops.m_tokenQueue[n2] : null;
        return string;
    }

    public void initMatchPattern(Compiler compiler, String string, PrefixResolver prefixResolver) throws TransformerException {
        this.m_ops = compiler;
        this.m_namespaceContext = prefixResolver;
        Lexer lexer = new Lexer(compiler, prefixResolver, this);
        lexer.tokenize(string);
        this.m_ops.m_opMap[0] = 30;
        this.m_ops.m_opMap[1] = 2;
        this.nextToken();
        this.Pattern();
        if (this.m_token != null) {
            String string2 = "";
            while (this.m_token != null) {
                string2 = String.valueOf(string2) + "'" + this.m_token + "'";
                this.nextToken();
                if (this.m_token == null) continue;
                string2 = String.valueOf(string2) + ", ";
            }
            this.error(25, new Object[]{string2});
        }
        this.m_ops.m_opMap[this.m_ops.m_opMap[1]] = -1;
        this.m_ops.m_opMap[1] = this.m_ops.m_opMap[1] + 1;
        this.m_ops.shrink();
    }

    public void initXPath(Compiler compiler, String string, PrefixResolver prefixResolver) throws TransformerException {
        this.m_ops = compiler;
        this.m_namespaceContext = prefixResolver;
        Lexer lexer = new Lexer(compiler, prefixResolver, this);
        lexer.tokenize(string);
        this.m_ops.m_opMap[0] = 1;
        this.m_ops.m_opMap[1] = 2;
        this.nextToken();
        this.Expr();
        if (this.m_token != null) {
            String string2 = "";
            while (this.m_token != null) {
                string2 = String.valueOf(string2) + "'" + this.m_token + "'";
                this.nextToken();
                if (this.m_token == null) continue;
                string2 = String.valueOf(string2) + ", ";
            }
            this.error(25, new Object[]{string2});
        }
        compiler.shrink();
    }

    void insertOp(int n, int n2, int n3) {
        int n4 = this.m_ops.m_opMap[1];
        int n5 = n4 - 1;
        while (n5 >= n) {
            this.m_ops.m_opMap[n5 + n2] = this.m_ops.m_opMap[n5];
            --n5;
        }
        this.m_ops.m_opMap[n] = n3;
        this.m_ops.m_opMap[1] = n4 + n2;
    }

    final boolean lookahead(char c, int n) {
        String string;
        int n2 = this.m_queueMark + n;
        boolean bl = n2 <= this.m_ops.m_tokenQueueSize && n2 > 0 && this.m_ops.m_tokenQueueSize != 0 ? ((string = (String)this.m_ops.m_tokenQueue[n2 - 1]).length() == 1 ? string.charAt(0) == c : false) : false;
        return bl;
    }

    private final boolean lookahead(String string, int n) {
        String string2;
        boolean bl = this.m_queueMark + n <= this.m_ops.m_tokenQueueSize ? ((string2 = (String)this.m_ops.m_tokenQueue[this.m_queueMark + (n - 1)]) != null ? string2.equals(string) : string == null) : string == null;
        return bl;
    }

    private final boolean lookbehind(char c, int n) {
        boolean bl;
        int n2 = this.m_queueMark - (n + 1);
        if (n2 >= 0) {
            String string = (String)this.m_ops.m_tokenQueue[n2];
            if (string.length() == 1) {
                char c2;
                char c3 = c2 = string == null ? (char)'|' : (char)string.charAt(0);
                bl = c2 == '|' ? false : c2 == c;
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean lookbehindHasToken(int n) {
        boolean bl;
        if (this.m_queueMark - n > 0) {
            String string = (String)this.m_ops.m_tokenQueue[this.m_queueMark - (n - 1)];
            int n2 = string == null ? 124 : (int)string.charAt(0);
            bl = n2 != 124;
        } else {
            bl = false;
        }
        return bl;
    }

    private final void nextToken() {
        if (this.m_queueMark < this.m_ops.m_tokenQueueSize) {
            this.m_token = (String)this.m_ops.m_tokenQueue[this.m_queueMark++];
            this.m_tokenChar = this.m_token.charAt(0);
        } else {
            this.m_token = null;
            this.m_tokenChar = '\u0000';
        }
    }

    private final void prevToken() {
        if (this.m_queueMark > 0) {
            --this.m_queueMark;
            this.m_token = (String)this.m_ops.m_tokenQueue[this.m_queueMark];
            this.m_tokenChar = this.m_token.charAt(0);
        } else {
            this.m_token = null;
            this.m_tokenChar = '\u0000';
        }
    }

    public void setErrorHandler(ErrorListener errorListener) {
        this.m_errorListener = errorListener;
    }

    final boolean tokenIs(char c) {
        return this.m_token != null ? this.m_tokenChar == c : false;
    }

    final boolean tokenIs(String string) {
        return this.m_token != null ? this.m_token.equals(string) : string == null;
    }

    void warn(int n, Object[] objectArray) throws TransformerException {
        String string = XSLMessages.createXPATHWarning(n, objectArray);
        ErrorListener errorListener = this.getErrorListener();
        if (errorListener != null) {
            errorListener.warning(new TransformerException(string, this.m_sourceLocator));
        } else {
            System.err.println(string);
        }
    }
}

