
import com.ddtek.xmlconverter.ConverterFactory;
import com.ddtek.xmlconverter.ConverterResolver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.FeatureKeys;

// Run an XSLT
// The following directories and jars must be in your classpath:
// C:/Users/ipedruzz/Documents/SSDN/JonGallegos
// C:/Program Files (x86)/Stylus Studio 2010 XML Enterprise Suite/Components/XML Converters for Java/lib/XMLConverters.jar
// C:/Program Files (x86)/Stylus Studio 2010 XML Enterprise Suite/bin/saxonsa.jar
//

public class run {

	public static void main(String[] args) throws Exception {

		ConverterResolver resolver = new ConverterFactory().newResolver();

		String       inputUrl   = args[0];//"converter:CSV:first=yes:quotes=":double=yes:root=PDDA:row=Row?file:///c:/Users/ipedruzz/Documents/SSDN/JonGallegos/PDDAInShort.csv";
		InputStream  inStream   = null;
		String       outputUrl  = args[1];//"converter:TAB:encoding=utf-8:quotes=:collapse=no:root=Document:row=Row?file:///c:/Users/ipedruzz/Documents/SSDN/JonGallegos/InitialProcessStructure.txt";
		OutputStream outStream  = null;
		String       xsltUrl    = args[2];//"file:///c:/Users/ipedruzz/Documents/SSDN/JonGallegos/NAPLMiPPDA_TcMSE10a.xsl";


		try {
			TransformerFactory tFactory = new net.sf.saxon.TransformerFactoryImpl();
			tFactory.setAttribute(FeatureKeys.RECOGNIZE_URI_QUERY_PARAMETERS, Boolean.TRUE);
			tFactory.setAttribute(FeatureKeys.STRIP_WHITESPACE, "ignorable");
			tFactory.setAttribute(FeatureKeys.VERSION_WARNING, Boolean.FALSE);

			Transformer transformer = tFactory.newTransformer(new StreamSource(xsltUrl));
			transformer.setURIResolver(resolver);

			StreamSource source = (StreamSource)resolver.resolve(inputUrl, null);
			if (source==null) throw new IOException("Unable to resolve " + inputUrl);
			inStream = source.getInputStream();

			outStream = resolver.createOutputStream(outputUrl, null);
			if (outStream==null) throw new IOException("Unable to resolve " + outputUrl);

			System.out.println();
			System.out.println("XSLT starting.");
			transformer.transform(source,
			                      new StreamResult(outStream));
			System.out.println();
			System.out.println("XSLT finished.");
			outStream.close();
			inStream.close();
		} finally {
			if (outStream!=null) outStream.close();
			if (inStream!=null)   inStream.close();
		}
	}
}
