<?xml version="1.0"?>
<!-- Revised 7-17-2013; Stylesheet to transform ONIX 2 for books to be used with an external XML file 
	 containing BISAC subject codes and subject heading text; created by Dana Pearson; 
	 dbpearson metadata and XML services, dbpearsonmlis.com, dbpearsonmlis@gmail.com  -->

<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns="http://www.loc.gov/MARC21/slim">

	<xsl:output indent="yes" use-character-maps="ME-char"/>

	<xsl:character-map name="ME-char">
		<xsl:output-character character="&#x201C;" string='"'/>
		<xsl:output-character character="&#x201D;" string='"'/>
		<xsl:output-character character="&#xB9;" string=''/>
		<xsl:output-character character="&#xB2;" string=''/>
		<xsl:output-character character="&#xB3;" string=''/>
	</xsl:character-map>

	<xsl:variable name="sh" select="document('BISAC_code_and_text.xml')/headings"/>

	<xsl:template match="ONIXMessage | ONIXmessage">

		<collection xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://www.loc.gov/MARC21/slim http://www.loc.gov/standards/marcxml/schema/MARC21slim.xsd">
			<xsl:choose>
				<xsl:when test="product">
					<xsl:apply-templates select="product"/>
				</xsl:when>
				<xsl:when test="Product">
					<xsl:apply-templates select="Product"/>
				</xsl:when>
			</xsl:choose>
		</collection>

	</xsl:template>

	<xsl:template match="product">

		<record>
			<leader>
				<!-- 00-04 -->
				<xsl:text>     </xsl:text>
				<!-- 05 all ONIX records will have value n, new -->
				<xsl:text>n</xsl:text>
				<!-- 06 -->
				<xsl:text>a</xsl:text>
				<!-- 07 -->
				<xsl:text>m</xsl:text>
				<!-- 08 -->
				<xsl:text> </xsl:text>
				<!-- 09 -->
				<xsl:text> </xsl:text>
				<!-- 10 -->
				<xsl:text>2</xsl:text>
				<!-- 11 -->
				<xsl:text>2</xsl:text>
				<!-- 12-16 -->
				<xsl:text>     </xsl:text>
				<!-- 17 encoding level; all ONIX records will have value '5', Partial (preliminary) level -->
				<xsl:text>5</xsl:text>
				<!-- 18 -->
				<xsl:text> </xsl:text>
				<!-- 19 -->
				<xsl:text> </xsl:text>
				<!-- 20-23 -->
				<xsl:text>4500</xsl:text>
			</leader>

			<!-- construct 001 field with dummy text prepended to an ISBN; this is done with template named isbn1. -->
			<xsl:for-each select="productidentifier">
				<xsl:call-template name="isbn1"/>
			</xsl:for-each>

			<controlfield tag="006"><xsl:text>m\\\\</xsl:text>
			<!-- test for juvenile content with prefix of BASICMainSubject code -->
			<xsl:if test="b064">
				<xsl:for-each select="b064">
					<xsl:choose>
						<xsl:when test="substring(.,1,3)='JNF'"><xsl:text>j</xsl:text></xsl:when>
						<xsl:when test="substring(.,1,3)='JUV'"><xsl:text>j</xsl:text></xsl:when>
						<xsl:otherwise><xsl:text>\</xsl:text></xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
			</xsl:if>
				<xsl:text>o\\d\\\\\\\\</xsl:text>
			</controlfield>
			
			<controlfield tag="007"><xsl:text>cr\cn|||||||||</xsl:text></controlfield>

			<controlfield tag="008">
				<!-- 0-5 -->
				<xsl:text>      </xsl:text>
				<!-- set value for position 6 and 7-14; testing for the existence of publication date and copyright year -->
				<xsl:for-each select=".">
				<xsl:choose>
					<xsl:when test="not(b003 | b087)">
						<xsl:text>s20uu    </xsl:text>
					</xsl:when>      
					<xsl:when test="b003 and b087">t</xsl:when>
					<xsl:otherwise>s</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="b003 and b087">
						<xsl:value-of select="substring(b003,1,4)"/>
						<xsl:value-of select="b087"/>
					</xsl:when>
					<xsl:when test="not(b003 and b087)">
						<xsl:choose>
							<xsl:when test="b003">
								<xsl:if test="not(b087)">
									<xsl:value-of select="substring(b003,1,4)"/><xsl:text>    </xsl:text>
								</xsl:if>
							</xsl:when>
							<xsl:when test="not(b003)">
								<xsl:if test="b087">
									<xsl:text>    </xsl:text><xsl:value-of select="b087"/>
								</xsl:if>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
				</xsl:choose>
				</xsl:for-each>
				<!-- 15-21 -->
				<xsl:text>xx     </xsl:text>
				<!-- 22 Audience code -->
				<xsl:choose>
					<xsl:when test="audience">
					<xsl:for-each select="audience[1]">
						<xsl:choose>
							<xsl:when test="b206='01'">
								<xsl:text>g</xsl:text>
							</xsl:when>
							<xsl:when test="b206='02'">
								<xsl:text>j</xsl:text>
							</xsl:when>
							<xsl:when test="b206='03'">
								<xsl:text>d</xsl:text>
							</xsl:when>
							<xsl:when test="b206='04'">
								<xsl:text>j</xsl:text>
							</xsl:when>
							<xsl:when test="b206='05'">
								<xsl:text>e</xsl:text>
							</xsl:when>
							<xsl:when test="b206='06'">
								<xsl:text>f</xsl:text>
							</xsl:when>
							<xsl:when test="b206='07'">
								<xsl:text>f</xsl:text>
							</xsl:when>
							<xsl:when test="b206='08'">
								<xsl:text>e</xsl:text>
							</xsl:when>
						</xsl:choose>
					</xsl:for-each>
					</xsl:when>
					<!-- if Audience does not exist, test for juvenile content in BISAC code -->
					<xsl:when test="not(audience)">
						<xsl:if test="b064">
							<xsl:for-each select="b064">
								<xsl:choose>
									<xsl:when test="substring(.,1,3)='JNF'"><xsl:text>j</xsl:text></xsl:when>
									<xsl:when test="substring(.,1,3)='JUV'"><xsl:text>j</xsl:text></xsl:when>
									<xsl:otherwise><xsl:text> </xsl:text></xsl:otherwise>
								</xsl:choose>
							</xsl:for-each>
						</xsl:if>
					</xsl:when>
				</xsl:choose>
				<!-- 23 Form of item: online vs. electronic ('o' vs 's') -->
				<xsl:text>o</xsl:text>
				<!-- 24-32; 29 - Conference publication (value 0); 30 - Festschrift  (value 0); 31 – Index (value 0) -->
				<xsl:text>     000 </xsl:text>
				<!-- 33, if BISAC fiction, 1; if not fiction,0; if BISAC code missing, | - No attempte to code. -->
				<xsl:choose>
					<xsl:when test="b064">
						<xsl:for-each select="b064">
						<xsl:choose>
							<xsl:when test="substring(.,1,3)='FIC'"><xsl:text>1</xsl:text></xsl:when>
							<xsl:when test="substring(.,1,3)='JUV'"><xsl:text>1</xsl:text></xsl:when>
							<xsl:otherwise>0</xsl:otherwise>
						</xsl:choose>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise><xsl:text>|</xsl:text></xsl:otherwise>
				</xsl:choose>
				<!-- 34 biography test for BISAC codes beginning with BIO and JNF007 -->
				<xsl:choose>
					<xsl:when test="b064">
						<xsl:for-each select="b064">
							<xsl:choose>
								<xsl:when test="substring(.,1,3)='BIO'"><xsl:text>d</xsl:text></xsl:when>
								<xsl:when test="substring(.,1,6)='JNF007'"><xsl:text>d</xsl:text></xsl:when>
								<xsl:otherwise><xsl:text> </xsl:text></xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise><xsl:text>|</xsl:text></xsl:otherwise>
				</xsl:choose>
				<!-- 35-37 language; if not present, default is 'eng' not 'und' -->
				<xsl:choose>
					<xsl:when test="language">
						<xsl:value-of select="language/b252"/>
					</xsl:when>
					<xsl:otherwise>eng</xsl:otherwise>
				</xsl:choose>
				<!-- 38-39 -->
				<xsl:text> d</xsl:text>

			</controlfield>

			<!-- create 020 fields with both 10 and 13 digit ISBNs if they exist -->
			<xsl:for-each select="productidentifier">
				<xsl:choose>
					<xsl:when test="b221='02'">
						<datafield tag="020" ind1=" " ind2=" ">
							<subfield code="a">
								<xsl:value-of select="b244"/><xsl:text> (ebook)</xsl:text>
							</subfield>
						</datafield>
					</xsl:when>
					<xsl:when test="b221='15'">
						<datafield tag="020" ind1=" " ind2=" ">
							<subfield code="a">
								<xsl:value-of select="b244"/><xsl:text> (ebook)</xsl:text>
							</subfield>
						</datafield>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>

			<!-- test for Language/LanguageCode other than 'eng' if so, create 041 with $a LanguageCode content -->
			<xsl:for-each select="language">
				<xsl:choose>
					<xsl:when test="b252='spa'">
						<datafield tag="041" ind1=" " ind2=" ">
							<subfield code="a">
								<xsl:value-of select="b252"/>
							</subfield>
						</datafield>
					</xsl:when>
					<xsl:when test="b252='fre'">
						<datafield tag="041" ind1=" " ind2=" ">
							<subfield code="a">
								<xsl:value-of select="b252"/>
							</subfield>
						</datafield>
					</xsl:when>
					<xsl:when test="b252='ger'">
						<datafield tag="041" ind1=" " ind2=" ">
							<subfield code="a">
								<xsl:value-of select="b252"/>
							</subfield>
						</datafield>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>

			<!-- BASICMainSubject: The subject scheme name is now officially “BISAC”, -->
			<!-- but the ONIX data element name cannot be changed for reasons of upwards compatibility. -->
			<xsl:for-each select="b064">
				<datafield tag="072" ind1=" " ind2="7">
					<subfield code="a">
						<xsl:value-of select="substring(.,1,3)"/>
					</subfield>
					<subfield code="x">
						<xsl:value-of select="substring(.,4,6)"/>
					</subfield>
					<subfield code="2">bisacsh</subfield>
				</datafield>
			</xsl:for-each>


			<!-- account for BICMainSubject -->
			<xsl:for-each select="b065">
				<datafield tag="072" ind1=" " ind2="7">
					<subfield code="a">
						<xsl:value-of select="."/>
					</subfield>
					<subfield code="2">bicssc</subfield>
				</datafield>
			</xsl:for-each>

		<!-- the construction of 100 and 700 fields is done in another template -->
		<xsl:for-each select="contributor">
			<xsl:call-template name="author1"/>
		</xsl:for-each>

		<!-- the construction of the 245 field is done in another template -->
		<xsl:for-each select="title[1]">
			<xsl:choose>
				<xsl:when test="following-sibling::language/b252='spa'">
					<xsl:call-template name="Spanish">
						<xsl:with-param name="spanish" select="b203"/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="Title">
						<xsl:with-param name="titleString" select="b203"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>

		<xsl:choose>
			<!-- Test for the existence of EditionNumber -->
			<xsl:when test="b057">
				<xsl:for-each select="b057">
					<datafield tag="250" ind1=" " ind2=" ">
						<subfield code="a">
							<xsl:value-of select="."/>
								<xsl:choose>
									<xsl:when test=".='1'"><xsl:text>st ed.</xsl:text></xsl:when>
									<xsl:when test=".='2'"><xsl:text>nd ed.</xsl:text></xsl:when>
									<xsl:when test=".='3'"><xsl:text>rd ed.</xsl:text></xsl:when>
									<xsl:otherwise><xsl:text>th ed.</xsl:text></xsl:otherwise>
								</xsl:choose>
						</subfield>
					</datafield>
				</xsl:for-each>
			</xsl:when>
			<xsl:when test="not(b057)">
				<xsl:for-each select="b058">
					<datafield tag="250" ind1=" " ind2=" ">
						<subfield code="a">
							<xsl:value-of select="."/>
						</subfield>
					</datafield>
				</xsl:for-each>
			</xsl:when>
		</xsl:choose>
		
			<!-- test for the existence of Publisher element; test for PublisherRole (b291) with value of '07' to use
				 ImprintName (b079) value for constructing a second 260$b; test for existence of copyright year as in 008
				  and add appropriate punctuation; e.g. $c2012, c1985.  -->

			<xsl:choose>
				<xsl:when test="publisher">
					<xsl:for-each select="publisher">
					<xsl:variable name="copyrightDate" select="following-sibling::b087"/>
					<xsl:variable name="imprint" select="preceding-sibling::imprint/b079"/>
						<datafield tag="260" ind1=" " ind2=" ">
							<subfield code="a">
								<xsl:choose>
									<xsl:when test="following-sibling::b209">
										<xsl:value-of select="following-sibling::b209"/>
										<xsl:text> :</xsl:text>
									</xsl:when>
									<xsl:otherwise>[S.l.] :</xsl:otherwise>
								</xsl:choose>
							</subfield>
					<xsl:choose>	
						<xsl:when test="b081">
							<xsl:choose>
								<xsl:when test="b291='07'">
									<subfield code="b">
										<xsl:if test="$imprint">
											<xsl:value-of select="$imprint"/><xsl:text> :</xsl:text>
										</xsl:if>
									</subfield>
									<subfield code="b">
										<xsl:value-of select="b081"/><xsl:text>,</xsl:text>
									</subfield>
								</xsl:when>
								<xsl:when test="not(b291='07')">
									<subfield code="b">
										<xsl:value-of select="b081"/><xsl:text>,</xsl:text>
									</subfield>
								</xsl:when>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>[S.n.],</xsl:otherwise>
					</xsl:choose>
						<subfield code="c">
							<xsl:choose>
								<xsl:when test="following-sibling::b003">
									<xsl:value-of select="substring(following-sibling::b003,1,4)"/>
										<xsl:choose>
						   					<xsl:when test="$copyrightDate">
												<xsl:text>, c</xsl:text>
													<xsl:value-of select="$copyrightDate"/>
								    			<xsl:text>.</xsl:text>
							   				</xsl:when>
							   				<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:when test="not(following-sibling::b003)">
										<xsl:choose>
											<xsl:when test="$copyrightDate">
												<xsl:text>c</xsl:text>
													<xsl:value-of select="$copyrightDate"/>
												<xsl:text>.</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>[20--?]</xsl:text></xsl:otherwise>
										</xsl:choose>
									</xsl:when>
								</xsl:choose>
						</subfield>
					</datafield>
				</xsl:for-each>
			</xsl:when>

				
			<xsl:otherwise>
				<datafield tag="260" ind1=" " ind2=" ">
					<xsl:choose>
						<xsl:when test="b209">
							<subfield code="a">
								<xsl:value-of select="b209"/>
							</subfield>
						</xsl:when>
						<xsl:otherwise>
							<subfield code="a">[S.l.] :</subfield>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="imprint">
							<subfield code="b"><xsl:value-of select="imprint/b079"/></subfield>
						</xsl:when>
						<xsl:otherwise>
							<subfield code="b">[S.n.],</subfield>
						</xsl:otherwise>
					</xsl:choose>
							<subfield code="c">
							<xsl:choose>
							<xsl:when test="b003">
									<xsl:value-of select="substring(b003,1,4)"/>
										<xsl:choose>
							   				<xsl:when test="b087"><xsl:text>, c</xsl:text><xsl:value-of select="b087"/>
							    			<xsl:text>.</xsl:text>
							   				</xsl:when>
							   				<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</xsl:when>
								<xsl:otherwise>[20--?]</xsl:otherwise>
							</xsl:choose>
						</subfield>
					</datafield>
				</xsl:otherwise>
			</xsl:choose>


		<!-- Test for number of pages not equal to zero; also test for missing NumberOfPages (b061) element -->
		<xsl:choose>
			<xsl:when test="b061">
				<xsl:for-each select="b061">
					<xsl:choose>
						<xsl:when test=". != '0'">
							<datafield tag="300" ind1=" " ind2=" ">
								<subfield code="a">1 online resource (<xsl:value-of select="."/> p.)</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test=". = '0'">
							<datafield tag="300" ind1=" " ind2=" ">
								<subfield code="a">1 online resource.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:for-each>
			</xsl:when>
			<xsl:otherwise>
				<datafield tag="300" ind1=" " ind2=" ">
					<subfield code="a">1 online resource.</subfield>
				</datafield>
			</xsl:otherwise>
		</xsl:choose>

		<!-- create 490/830 fields if TitleOfSeries element exists; if NumberWithinSeries exists, create subfield v -->
		<xsl:for-each select="series">
		<xsl:variable name="series" select="b018"/>
			<datafield tag="490" ind1="1" ind2=" ">
				<subfield code="a">
					<xsl:value-of select="$series"/>
					<xsl:choose>
						<xsl:when test="b019">
						<xsl:text>; </xsl:text>
						</xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</subfield>
				<xsl:if test="b019">
				<subfield code="v">
					<xsl:value-of select="b019"/>
				</subfield>
				</xsl:if>
			</datafield>
			<datafield tag="830" ind1=" " ind2="0">
				<xsl:choose>
					<xsl:when test="following-sibling::language/b252 = 'spa'">
						<xsl:choose>
							<xsl:when test="substring($series,1,3)='El '">
								<subfield code="a">
									<xsl:value-of select="substring($series,4)"/>
										<xsl:choose>
											<xsl:when test="b019">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="b019">
								<subfield code="v">
									<xsl:value-of select="b019"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
							<xsl:when test="substring($series,1,3)= 'La '">
								<subfield code="a">
									<xsl:value-of select="substring($series,4)"/>
										<xsl:choose>
											<xsl:when test="b019">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="b019">
								<subfield code="v">
									<xsl:value-of select="b019"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
							<xsl:when test="substring($series,1,3)='Lo '">
								<subfield code="a">
									<xsl:value-of select="substring($series,4)"/>
										<xsl:choose>
											<xsl:when test="b019">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="b019">
								<subfield code="v">
									<xsl:value-of select="b019"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
							<xsl:when test="substring($series,1,3)='Un '">
								<subfield code="a">
									<xsl:value-of select="substring($series,4)"/>
										<xsl:choose>
											<xsl:when test="b019">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="b019">
								<subfield code="v">
									<xsl:value-of select="b019"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
							<xsl:when test="substring($series,1,4)='Las '">
								<subfield code="a">
									<xsl:value-of select="substring($series,5)"/>
										<xsl:choose>
											<xsl:when test="b019">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="b019">
								<subfield code="v">
									<xsl:value-of select="b019"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
							<xsl:when test="substring($series,1,4)='Los ' ">
								<subfield code="a">
									<xsl:value-of select="substring($series,5)"/>
										<xsl:choose>
											<xsl:when test="b019">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="b019">
								<subfield code="v">
									<xsl:value-of select="b019"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
							<xsl:when test="substring($series,1,4)='Una '">
								<subfield code="a">
									<xsl:value-of select="substring($series,5)"/>
										<xsl:choose>
											<xsl:when test="b019">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="b019">
								<subfield code="v">
									<xsl:value-of select="b019"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="not(following-sibling::language/b252='spa')">
						<xsl:choose>
							<xsl:when test="substring($series,1,2)='A '">
								<subfield code="a">
									<xsl:value-of select="substring($series,3)"/>
										<xsl:choose>
											<xsl:when test="b019">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="b019">
								<subfield code="v">
									<xsl:value-of select="b019"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
							<xsl:when test="substring($series,1,3)='An '">
								<subfield code="a">
									<xsl:value-of select="substring($series,4)"/>
										<xsl:choose>
											<xsl:when test="b019">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="b019">
								<subfield code="v">
									<xsl:value-of select="b019"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
							<xsl:when test="substring($series,1,4)='The '">
								<subfield code="a">
									<xsl:value-of select="substring($series,5)"/>
										<xsl:choose>
											<xsl:when test="b019">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="b019">
								<subfield code="v">
									<xsl:value-of select="b019"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<subfield code="a">
									<xsl:value-of select="$series"/>
										<xsl:choose>
											<xsl:when test="b019">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="b019">
								<subfield code="v">
									<xsl:value-of select="b019"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
				</xsl:choose>
			</datafield>		
		</xsl:for-each>
		
		<!-- epublication type; text for value of PDF and EPUB to create 516 -->
		<xsl:if test="b211">
		<xsl:choose>
			<xsl:when test="b211/following-sibling::b213">
				<datafield tag="516" ind1=" " ind2=" ">
					<subfield  code="a">
						<xsl:value-of select="b213"/>
					</subfield>
				</datafield>
			</xsl:when>
			<xsl:when test="not(b211/following-sibling::b213)">
				<datafield tag="516" ind1=" " ind2=" ">
					<subfield  code="a">
						<xsl:choose>
							<xsl:when test="b211 eq '002'"><xsl:text>PDF</xsl:text></xsl:when>
							<xsl:when test="b211 eq '029'"><xsl:text>EPUB</xsl:text></xsl:when>
							<!-- <xsl:when test="b211 eq '001'"><xsl:text>HTML</xsl:text></xsl:when> -->
						</xsl:choose>
					</subfield>
				</datafield>				
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
		</xsl:if> 

		<!-- test for types of description and review quotes; create table of contents, biographical note; see List 33
			 Other Text Type Code 	-->	
		<xsl:for-each-group select="othertext" group-by="d102">
			<xsl:choose>
				<xsl:when test="d102='04'">
					<xsl:choose>
						<xsl:when test="string-length(d104) &lt; 5000">
							<datafield tag="505" ind1="0" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="normalize-space(d104)"/>
								</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="string-length(d104) &gt; 5000">
							<datafield tag="505" ind1="0" ind2=" ">
								<subfield code="a"><xsl:text>FIELD LENGTH EXCEEDED</xsl:text></subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>

			<xsl:choose>
				<xsl:when test="d102='03'">
					<xsl:choose>
						<xsl:when test="string-length(d104) &lt; 5000">
							<datafield tag="520" ind1=" " ind2=" ">
								<subfield code="a">
									<xsl:value-of select="normalize-space(current-group()[1]/d104)"/>
								</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="string-length(d104) &gt; 5000">
							<datafield tag="520" ind1=" " ind2=" ">
								<subfield code="a"><xsl:text>FIELD LENGTH EXCEEDED</xsl:text></subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>

				<xsl:when test="parent::*/child::othertext/child::d102= '03'"/>

				<xsl:when test="d102='01'">
					<xsl:choose>
						<xsl:when test="string-length(d104) &lt; 5000">
							<datafield tag="520" ind1=" " ind2=" ">
								<subfield code="a">
									<xsl:value-of select="normalize-space(current-group()[1]/d104)"/>
								</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="string-length(d104) &gt; 5000">
							<datafield tag="520" ind1=" " ind2=" ">
								<subfield code="a"><xsl:text>FIELD LENGTH EXCEEDED</xsl:text></subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
				
				<xsl:when test="parent::*/child::othertext/child::d102= '01'"/>

				<xsl:when test="d102='02'">
					<xsl:choose>
						<xsl:when test="string-length(d104) &lt; 5000">
							<datafield tag="520" ind1=" " ind2=" ">
								<subfield code="a">
									<xsl:value-of select="normalize-space(current-group()[1]/d104)"/>
								</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="string-length(d104) &gt; 5000">
							<datafield tag="520" ind1=" " ind2=" ">
								<subfield code="a"><xsl:text>FIELD LENGTH EXCEEDED</xsl:text></subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>

			<xsl:choose>
				<xsl:when test="d102='08'">
					<xsl:choose>
						<xsl:when test="string-length(d104) &lt; 5000">
							<datafield tag="520" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="normalize-space(current-group()[1]/d104)"/>
								</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="string-length(d104) &gt; 5000">
							<datafield tag="520" ind1="1" ind2=" ">
								<subfield code="a"><xsl:text>FIELD LENGTH EXCEEDED</xsl:text></subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>

				<xsl:when test="parent::*/child::othertext/child::d102= '08'"/>

				<xsl:when test="d102='05'">
					<xsl:choose>
						<xsl:when test="string-length(d104) &lt; 5000">
							<datafield tag="520" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="normalize-space(current-group()[1]/d104)"/>
								</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="string-length(d104) &gt; 5000">
							<datafield tag="520" ind1="1" ind2=" ">
								<subfield code="a"><xsl:text>FIELD LENGTH EXCEEDED</xsl:text></subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>

				<xsl:when test="parent::*/child::othertext/child::d102= '05'"/>

				<xsl:when test="d102='07'">
					<xsl:choose>
						<xsl:when test="string-length(d104) &lt; 5000">
							<datafield tag="520" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="normalize-space(current-group()[1]/d104)"/>
								</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="string-length(d104) &gt; 5000">
							<datafield tag="520" ind1="1" ind2=" ">
								<subfield code="a"><xsl:text>FIELD LENGTH EXCEEDED</xsl:text></subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>

			<xsl:choose>
				<xsl:when test="d102='13'">
				<xsl:if test="not(preceding-sibling::contributor/b044)">
					<xsl:choose>
						<xsl:when test="string-length(d104) &lt; 5000">
							<datafield tag="545" ind1="0" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="normalize-space(current-group()[1]/d104)"/>
								</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="string-length(d104) &gt; 5000">
							<datafield tag="545" ind1="0" ind2=" ">
								<subfield code="a"><xsl:text>FIELD LENGTH EXCEEDED</xsl:text></subfield>
							</datafield>
						</xsl:when>				
					</xsl:choose>
				</xsl:if>
				</xsl:when>
			</xsl:choose>

		</xsl:for-each-group>  

		<!-- audience content of $a is based on the OCLC terminology for the AudienceCode values -->
		<xsl:for-each select="audience">
			<datafield tag="521" ind1=" " ind2=" ">
				<subfield code="a">
					<xsl:choose>
						<xsl:when test="b206 = '01'"><xsl:text>General adult.</xsl:text></xsl:when>
						<xsl:when test="b206 = '02'"><xsl:text>Children/juvenile.</xsl:text></xsl:when>
						<xsl:when test="b206 = '03'"><xsl:text>Young adult.</xsl:text></xsl:when>
						<xsl:when test="b206 = '04'"><xsl:text>Primary and secondary school.</xsl:text></xsl:when>
						<xsl:when test="b206 = '05'"><xsl:text>College/higher education.</xsl:text></xsl:when>
						<xsl:when test="b206 = '06'"><xsl:text>Professional and scholarly.</xsl:text></xsl:when>
						<xsl:when test="b206 = '07'"><xsl:text>Intended for use in teaching English as second language.</xsl:text></xsl:when>
						<xsl:when test="b206 = '08'"><xsl:text>Adult education.</xsl:text></xsl:when>
					</xsl:choose>
				</subfield>
			</datafield>
		</xsl:for-each>

		<!-- if AudienceRestrictionFlag (j146) element exists, create 521 with the content of AudienceRestrictionNote(j147)element -->
		<xsl:for-each select="j147">
			<xsl:if test="preceding-sibling::j146">
				<datafield tag="521" ind1=" " ind2=" ">
					<subfield code="a">
						<xsl:value-of select="normalize-space(.)"/>
					</subfield>
				</datafield>
			</xsl:if>
		</xsl:for-each>
		
		<!-- if BiographicalNote (b044) in the contributor composite, create 545 -->
		<xsl:for-each select="contributor[1]/b044">
		<xsl:if test=".">
		<xsl:if test="preceding-sibling::b035 = 'A01'">
			<xsl:choose>
				<xsl:when test="string-length(.) &lt; 5000">
					<datafield tag="545" ind1="0" ind2=" ">
						<subfield code="a">
							<xsl:value-of select="normalize-space(.)"/>
						</subfield>
					</datafield>
				</xsl:when>
				<xsl:when test="string-length(.) &gt; 5000">
					<datafield tag="545" ind1="0" ind2=" ">
						<subfield code="a"><xsl:text>FIELD LENGTH EXCEEDED</xsl:text></subfield>
					</datafield>
				</xsl:when>
			</xsl:choose>
		</xsl:if>
		</xsl:if>

		</xsl:for-each>

		<!-- select language if not English -->
			<xsl:for-each select="language">
				<xsl:choose>
					<xsl:when test="b252='spa'">
						<datafield tag="546" ind1=" " ind2=" ">
							<subfield code="a">
								<xsl:text>Text in Spanish.</xsl:text>
							</subfield>
						</datafield>
					</xsl:when>
					<xsl:when test="b252='fre'">
						<datafield tag="546" ind1=" " ind2=" ">
							<subfield code="a">
								<xsl:text>Text in French.</xsl:text>
							</subfield>
						</datafield>
					</xsl:when>
					<xsl:when test="b252='ger'">
						<datafield tag="546" ind1=" " ind2=" ">
							<subfield code="a">
								<xsl:text>Text in German.</xsl:text>
							</subfield>
						</datafield>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>

		<datafield tag="588" ind1=" " ind2=" ">
			<subfield code="a"><xsl:text>Description based on publisher data.</xsl:text></subfield>
		</datafield>

		<!-- use external XML file with subject heading text matched to codes when not found to construct 650 field for BASICMainSubject,
			MainSubject and Subject elements.  -->
		<xsl:if test="not(b064)">
			<datafield tag="650" ind1=" " ind2="7">
				<subfield code="a"><xsl:text>NoBISACMainSubjectCode</xsl:text></subfield>
			</datafield>
		</xsl:if>
		<xsl:for-each select="b064">
		<xsl:choose>
			<xsl:when test=".=$sh/*/code">
				<xsl:call-template name="subj1">
					<xsl:with-param name="s" select="."/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<datafield tag="650" ind1=" " ind2="7">
					<subfield code="a"><xsl:text>NOMATCH for Bisac subject code </xsl:text><xsl:value-of select="."/></subfield>
				</datafield>
			</xsl:otherwise>
		</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select="mainsubject">
		<xsl:variable name="t1" select="tokenize(b070, '/')"/>
			<xsl:choose>
				<xsl:when test="b070">
					<xsl:if test="./b191='10'">
						<datafield tag="650" ind1=" " ind2="7">
							<subfield code="a">
								<xsl:value-of select="normalize-space($t1[1])"/>
							</subfield>
							<xsl:if test="$t1[2]">
								<subfield code="x">
									<xsl:value-of select="normalize-space($t1[2])"/>
									<xsl:if test="not($t1[3])">
										<xsl:text>.</xsl:text>
									</xsl:if>
								</subfield>
							</xsl:if>
							<xsl:if test="$t1[3]">
								<subfield code="x">
								<xsl:value-of select="normalize-space($t1[3])"/>
								<xsl:if test="not($t1[4])">
									<xsl:text>.</xsl:text>
								</xsl:if>
								</subfield>
							</xsl:if>
							<xsl:if test="$t1[4]">
								<subfield code="x">
									<xsl:value-of select="normalize-space($t1[4])"/><xsl:text>.</xsl:text>
								</subfield>
							</xsl:if>
							<subfield code="2">bisacsh</subfield>
						</datafield>
					</xsl:if>
				</xsl:when>
				<xsl:when test="not(b070)">
					<xsl:if test="b191='10'">
						<xsl:for-each select="b069">
							<xsl:choose>
								<xsl:when test=".=$sh/*/code">
									<xsl:call-template name="subj2">
										<xsl:with-param name="s2" select="."/>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
									<datafield tag="650" ind1=" " ind2="7">
										<subfield code="a">
											<xsl:text>NOMATCH for subject code </xsl:text><xsl:value-of select="."/>
										</subfield>
									</datafield>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
					</xsl:if>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select="subject">
		<xsl:variable name="t1" select="tokenize(b070, '/')"/>
			<xsl:choose>
				<xsl:when test="b070">
					<xsl:if test="b067='10'">
						<datafield tag="650" ind1=" " ind2="7">
							<subfield code="a">
								<xsl:value-of select="normalize-space($t1[1])"/>
							</subfield>
							<xsl:if test="$t1[2]">
								<subfield code="x">
									<xsl:value-of select="normalize-space($t1[2])"/>
									<xsl:if test="not($t1[3])">
										<xsl:text>.</xsl:text>
									</xsl:if>
								</subfield>
							</xsl:if>
							<xsl:if test="$t1[3]">
								<subfield code="x">
									<xsl:value-of select="normalize-space($t1[3])"/>
									<xsl:if test="not($t1[4])">
										<xsl:text>.</xsl:text>
									</xsl:if>
								</subfield>
							</xsl:if>
							<xsl:if test="$t1[4]">
								<subfield code="x">
									<xsl:value-of select="normalize-space($t1[4])"/><xsl:text>.</xsl:text>
								</subfield>
							</xsl:if>
							<subfield code="2">bisacsh</subfield>
						</datafield>
					</xsl:if>
				</xsl:when>
				<xsl:when test="not(b070)">
					<xsl:if test="b067='10'">
						<xsl:for-each select="b069">
							<xsl:choose>
								<xsl:when test=".=$sh/*/code">
									<xsl:call-template name="subj3">
										<xsl:with-param name="s3" select="."/>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
									<datafield tag="650" ind1=" " ind2="7">
										<subfield code="a">
											<xsl:text>NOMATCH for subject code </xsl:text><xsl:value-of select="."/>
										</subfield>
									</datafield>
								</xsl:otherwise>									
							</xsl:choose>
						</xsl:for-each>
					</xsl:if>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each> 

		<!-- test related product composite for RelationCode (h208) equals value of '13' (epublication based on printed product) -->
		<xsl:for-each-group select="relatedproduct" group-by="h208">
		<xsl:variable name="aut">
			<xsl:if test="parent::*/child::contributor[1]/child::b035='A01'">
			<xsl:for-each select="parent::*/child::contributor[1]">
				<xsl:choose>
					<xsl:when test="b037">
						<xsl:value-of select="b037"/>
					</xsl:when>
					<xsl:when test="parent::*/child::contributor/child::b037"/>
					<xsl:when test="b040">
						<xsl:value-of select="./b040"/><xsl:text>, </xsl:text>
						<xsl:value-of select="./b039"/>
					</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
			</xsl:if>
		</xsl:variable>

		<xsl:choose>
			<xsl:when test="h208='13'">
				<datafield tag="776" ind1="0" ind2="8">
					<subfield code="i"><xsl:text>Print version: </xsl:text></subfield>
					<xsl:if test="$aut != ''">
					<subfield code="a">
						<xsl:value-of select="$aut"/><xsl:text>,</xsl:text>
					</subfield>
					</xsl:if>
					<subfield code="t">
						<xsl:value-of select="preceding-sibling::title/b203"/>
					</subfield>
					<subfield code="z">
						<xsl:value-of select="current-group()[1]/productidentifier/b244"/>
					</subfield>
				</datafield>
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
		</xsl:for-each-group>

		<!-- for ONIX records that include a website composite element; value of '02', Publisher’s website for a specified work;
			 value of '36', Supplier’s website for a specified work -->
		<xsl:for-each select="website">
			<xsl:choose>
				<xsl:when test="b367='02'">
					<datafield tag="856" ind1="4" ind2="2">
						<subfield code="y">BUY NOW</subfield>
						<subfield code="u">
							<xsl:value-of select="b295"/>
						</subfield>
					</datafield>
				</xsl:when>
				<xsl:when test="parent::*/child::website/child::b367 = '02'"/>
				<xsl:when test="b367='36'">
					<datafield tag="856" ind1="4" ind2="2">
						<subfield code="y">BUY NOW</subfield>
						<subfield code="u">
							<xsl:value-of select="b295"/>
							</subfield>
						</datafield>
				</xsl:when>
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>
			
	 </record>
	</xsl:template>

	<!-- order of product identifier types for constructing the 001 field; use 13 digit ISBN if available;
		 if not, a 10 digit ISBN if available;  if not, publisher's or wholesaler's product number if present,
		 otherwise nothing; product identifier code: List 5 
	<xsl:template name="isbn1" match="productidentifier">
   		<xsl:choose>
     		<xsl:when test="child::b221 = '15'">
       			<controlfield tag="001">
		    	    <xsl:value-of select="b244"/>
       			</controlfield>
     		</xsl:when>
     		<xsl:when test="parent::*/child::productidentifier/child::b221 = '15'"/>
     		<xsl:when test="child::b221 = '02'">
       			<controlfield tag="001">
         			<xsl:value-of select="b244"/>
       			</controlfield>
     		</xsl:when>
			<xsl:when test="parent::*/child::productidentifier/child::b221 = '02'"/>
     		<xsl:when test="child::b221 = '01'">
       			<controlfield tag="001">
         			<xsl:value-of select="b244"/>
       			</controlfield>
     		</xsl:when>
			<xsl:otherwise></xsl:otherwise>
   		</xsl:choose>
 	</xsl:template>  -->

	<!-- use publisher's or wholesaler's product number if present, if not, use 13 digit ISBN if available;
		 if not, a 10 digit ISBN; otherwise nothing; product identifier code: List 5 -->
	<xsl:template name="isbn1" match="productidentifier">
   		<xsl:choose>
     		<xsl:when test="child::b221 = '01'">
       			<controlfield tag="001">
		    	    <xsl:value-of select="b244"/>
       			</controlfield>
     		</xsl:when>
     		<xsl:when test="parent::*/child::productidentifier/child::b221 = '01'"/>
     		<xsl:when test="child::b221 = '15'">
       			<controlfield tag="001">
         			<xsl:value-of select="b244"/>
       			</controlfield>
     		</xsl:when>
			<xsl:when test="parent::*/child::productidentifier/child::b221 = '15'"/>
     		<xsl:when test="child::b221 = '02'">
       			<controlfield tag="001">
         			<xsl:value-of select="b244"/>
       			</controlfield>
     		</xsl:when>
			<xsl:otherwise></xsl:otherwise>
   		</xsl:choose>
 	</xsl:template> 

	<!-- test for author position to create 100 or 110 field, all others into 700 fields; test for ONIX name type varieties -->
	<xsl:template name="author1" match="contributor">
		<xsl:if test="position() =1">
		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="b035='A01'">
					<xsl:choose>
						<xsl:when test="b037">
							<datafield tag="100" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b037"/>
									<xsl:choose>
										<xsl:when test="b042">
											<xsl:text>,</xsl:text>
										</xsl:when>
										<xsl:when test="not(b042)">
											<xsl:text>.</xsl:text>
										</xsl:when>
									</xsl:choose>
								</subfield>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</datafield>
						</xsl:when>
						<xsl:when test="not(parent::*/child::contributor/child::b037)"/>
						<xsl:when test="b040">
							<datafield tag="100" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b040"/><xsl:text>, </xsl:text>
									<xsl:value-of select="b039"/>
									<xsl:choose>
										<xsl:when test="b248|b042">
											<xsl:text>,</xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:text>.</xsl:text>
										</xsl:otherwise>
									</xsl:choose>
								</subfield>
								<xsl:if test="b248">
								<subfield code="c">
									<xsl:value-of select="b248"/>
									<xsl:choose>
										<xsl:when test="b042">
											<xsl:text>,</xsl:text>
										</xsl:when>
										<xsl:when test="not(b042)">
											<xsl:text>.</xsl:text>
										</xsl:when>
									</xsl:choose>
								</subfield>
								</xsl:if>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</datafield>
						</xsl:when>
						<xsl:when test="not(parent::*/child::contributor/child::b040)"/>
						<xsl:when test="b047">
							<datafield tag="110" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b047"/><xsl:text>.</xsl:text>
								</subfield>
							</datafield>
						</xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		</xsl:if>

		<xsl:if test="position() gt 1">
		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="b035='A01'">
					<xsl:choose>
						<xsl:when test="b037">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b037"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="not(parent::*/child::contributor/child::b037)"/>
						<xsl:when test="b040">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b040"/><xsl:text>, </xsl:text>
									<xsl:value-of select="b039"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b248">
								<subfield code="c">
									<xsl:value-of select="b248"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author.</subfield>
							</datafield>
						</xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		</xsl:if> 

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="b035='A03'">
					<xsl:choose>
						<xsl:when test="b037">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b037"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author of screenplay.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="not(parent::*/child::contributor/child::b037)"/>
						<xsl:when test="b040">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b040"/><xsl:text>, </xsl:text>
									<xsl:value-of select="b039"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b248">
								<subfield code="c">
									<xsl:value-of select="b248"/>
								</subfield>
								</xsl:if>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author of screenplay.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>		
		
		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="b035='A12'">
					<xsl:choose>
						<xsl:when test="b037">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b037"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">illustrator.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="not(parent::*/child::contributor/child::b037)"/>
						<xsl:when test="b040">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b040"/><xsl:text>, </xsl:text>
									<xsl:value-of select="b039"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b248">
								<subfield code="c">
									<xsl:value-of select="b248"/>
								</subfield>
								</xsl:if>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">illustrator.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="b035='B01'">
					<xsl:choose>
						<xsl:when test="child::b037">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b037"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">editor.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="not(parent::*/child::contributor/child::b037)"/>
						<xsl:when test="child::b040">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b040"/><xsl:text>, </xsl:text>
									<xsl:value-of select="b039"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b248">
								<subfield code="c">
									<xsl:value-of select="b248"/>
								</subfield>
								</xsl:if>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">editor.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="b047"></xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="b035='B06'">
					<xsl:choose>
						<xsl:when test="b037">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b037"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>								
								<subfield code="e">translator.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="not(parent::*/child::contributor/child::b037)"/>
						<xsl:when test="b040">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b040"/><xsl:text>, </xsl:text>
									<xsl:value-of select="b039"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b248">
								<subfield code="c">
									<xsl:value-of select="b248"/>
								</subfield>
								</xsl:if>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">translator.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="b035='B09'">
					<xsl:choose>
						<xsl:when test="b037">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b037"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">series editor.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="not(parent::*/child::contributor/child::b037)"/>
						<xsl:when test="b040">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b040"/><xsl:text>, </xsl:text>
									<xsl:value-of select="b039"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b248">
								<subfield code="c">
									<xsl:value-of select="b248"/>
								</subfield>
								</xsl:if>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">series editor.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="b035='A15'">
					<xsl:choose>
						<xsl:when test="b037">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b037"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author of introduction, etc.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="not(parent::*/child::contributor/child::b037)"/>
						<xsl:when test="b040">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b040"/><xsl:text>, </xsl:text>
									<xsl:value-of select="b039"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b248">
								<subfield code="c">
									<xsl:value-of select="b248"/>
								</subfield>
								</xsl:if>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author of introduction, etc.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="b035='A23'">
					<xsl:choose>
						<xsl:when test="b037">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b037"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author of introduction, etc.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="not(parent::*/child::contributor/child::b037)"/>
						<xsl:when test="b040">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b040"/><xsl:text>, </xsl:text>
									<xsl:value-of select="b039"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b248">
								<subfield code="c">
									<xsl:value-of select="b248"/>
								</subfield>
								</xsl:if>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author of introduction, etc.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="b035='A24'">
					<xsl:choose>
						<xsl:when test="b037">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b037"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author of introduction, etc.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="not(parent::*/child::contributor/child::b037)"/>
						<xsl:when test="b040">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b040"/><xsl:text>, </xsl:text>
									<xsl:value-of select="b039"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b248">
								<subfield code="c">
									<xsl:value-of select="b248"/>
								</subfield>
								</xsl:if>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author of introduction, etc.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="b035='A43'">
					<xsl:choose>
						<xsl:when test="b037">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b037"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">interviewer.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="not(parent::*/child::contributor/child::b037)"/>
						<xsl:when test="b040">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b040"/><xsl:text>, </xsl:text>
									<xsl:value-of select="b039"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b248">
								<subfield code="c">
									<xsl:value-of select="b248"/>
								</subfield>
								</xsl:if>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">interviewer.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="b035='A44'">
					<xsl:choose>
						<xsl:when test="b037">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b037"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">interviewee.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="not(parent::*/child::contributor/child::b037)"/>
						<xsl:when test="b040">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="b040"/><xsl:text>, </xsl:text>
									<xsl:value-of select="b039"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="b248">
								<subfield code="c">
									<xsl:value-of select="b248"/>
								</subfield>
								</xsl:if>
								<xsl:if test="b042">
								<subfield code="c">
									<xsl:value-of select="b042"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">interviewee.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		
	</xsl:template>

	<xsl:template name="Spanish" match="title">
		<xsl:param name="spanish"/>

		<xsl:variable name="ind1">
			<xsl:choose>
				<xsl:when test="following-sibling::contributor[1]/b035='A01'">
					<xsl:value-of select="1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="0"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="ind2">
			<xsl:for-each select="$spanish">
				<xsl:choose>
					<xsl:when test="substring(.,1,3)='El '">
						<xsl:value-of select="3"/>
					</xsl:when>
					<xsl:when test="substring(.,1,3)='La '">
						<xsl:value-of select="3"/>
					</xsl:when>
					<xsl:when test="substring(.,1,3)='Lo '">
						<xsl:value-of select="3"/>
					</xsl:when>
					<xsl:when test="substring(.,1,3)='Un '">
						<xsl:value-of select="3"/>
					</xsl:when>
					<xsl:when test="substring(.,1,4)='Las '">
						<xsl:value-of select="4"/>
					</xsl:when>
					<xsl:when test="substring(.,1,4)='Los '">
						<xsl:value-of select="4"/>
					</xsl:when>
					<xsl:when test="substring(.,1,4)='Una '">
						<xsl:value-of select="4"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="0"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</xsl:variable>

		<xsl:variable name="contributorID" select="following-sibling::contributor/b035"/>
		<xsl:variable name="contributor" as="xs:string+">
			<xsl:for-each select="following-sibling::contributor">
				<xsl:choose>
					<xsl:when test="b035='A01'">
						<xsl:choose>
							<xsl:when test="b036 | b047">
								<xsl:value-of select="b036 | b047"/>
							</xsl:when>
							<xsl:when test="not(parent::*/child::contributor/child::b036)"/>
							<xsl:when test="b040">
								<xsl:choose>
									<xsl:when test="b248">
										<xsl:value-of select="concat(b039, ' ', b040, ', ', b248)"/>
									</xsl:when>
									<xsl:when test="not(b248)">
										<xsl:value-of select="concat(b039, ' ', b040)"/>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
		</xsl:variable>

		<xsl:for-each select="$spanish">
			<datafield tag="245" ind1="{$ind1}" ind2="{$ind2}">

						<subfield code="a">
							<xsl:value-of select="."/>
						</subfield>
						<subfield code="h">[electronic resource]<xsl:choose>
							<xsl:when test="following-sibling::b029"><xsl:text> :</xsl:text></xsl:when>
							<xsl:when test="not(following-sibling::b029)">
								<xsl:choose>
									<xsl:when test="$contributorID[1]='A01'"><xsl:text> /</xsl:text></xsl:when>
									<xsl:when test="not($contributorID[1]='A01')"><xsl:text>.</xsl:text></xsl:when>
								</xsl:choose>
							</xsl:when></xsl:choose>
						</subfield>
						<xsl:choose>
							<xsl:when test="following-sibling::b029">
								<subfield code="b">
									<xsl:value-of select="following-sibling::b029"/><xsl:choose>
									<xsl:when test="$contributorID[1]='A01'"><xsl:text> /</xsl:text></xsl:when>
									<xsl:otherwise>.</xsl:otherwise></xsl:choose>
								</subfield>
							</xsl:when>
							<xsl:otherwise></xsl:otherwise>
						</xsl:choose>

						<xsl:choose>
							<xsl:when test="$contributorID='A01'">
								<subfield code="c">
									<xsl:value-of select="$contributor" separator=", "/>
									<xsl:text>.</xsl:text>
								</subfield>
							</xsl:when>
							<xsl:otherwise></xsl:otherwise>									
						</xsl:choose>

					</datafield>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="Title" match="title">
		<xsl:param name="titleString"/>

		<xsl:variable name="ind1">
			<xsl:choose>
				<xsl:when test="following-sibling::contributor[1]/b035='A01'">
					<xsl:value-of select="1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="0"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="ind2">
			<xsl:for-each select="$titleString">
				<xsl:choose>
					<xsl:when test="substring(.,1,2)='A '">
						<xsl:value-of select="2"/>
					</xsl:when>
					<xsl:when test="substring(.,1,3)='An '">
						<xsl:value-of select="3"/>
					</xsl:when>
					<xsl:when test="substring(.,1,4)='The '">
						<xsl:value-of select="4"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="0"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</xsl:variable>

		<xsl:variable name="contributorID" select="following-sibling::contributor/b035"/>
		<xsl:variable name="contributor" as="xs:string+">
			<xsl:for-each select="following-sibling::contributor">
				<xsl:choose>
					<xsl:when test="b035='A01'">
						<xsl:choose>
							<xsl:when test="b036 | b047">
								<xsl:value-of select="b036 | b047"/>
							</xsl:when>
							<xsl:when test="not(parent::*/child::contributor/child::b036)"/>
							<xsl:when test="b040">
								<xsl:choose>
									<xsl:when test="b248">
										<xsl:value-of select="concat(b039, ' ', b040, ', ', b248)"/>
									</xsl:when>
									<xsl:when test="not(b248)">
										<xsl:value-of select="concat(b039, ' ', b040)"/>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
		</xsl:variable>

		<xsl:for-each select="$titleString">
			<datafield tag="245" ind1="{$ind1}" ind2="{$ind2}">

						<subfield code="a">
							<xsl:value-of select="."/>
						</subfield>
						<subfield code="h">[electronic resource]<xsl:choose>
							<xsl:when test="following-sibling::b029"><xsl:text> :</xsl:text></xsl:when>
							<xsl:when test="not(following-sibling::b029)">
								<xsl:choose>
									<xsl:when test="$contributorID[1]='A01'"><xsl:text> /</xsl:text></xsl:when>
									<xsl:when test="not($contributorID[1]='A01')"><xsl:text>.</xsl:text></xsl:when>
								</xsl:choose>
							</xsl:when></xsl:choose>
						</subfield>
						<xsl:choose>
							<xsl:when test="following-sibling::b029">
								<subfield code="b">
									<xsl:value-of select="following-sibling::b029"/><xsl:choose>
									<xsl:when test="$contributorID[1]='A01'"><xsl:text> /</xsl:text></xsl:when>
									<xsl:otherwise>.</xsl:otherwise></xsl:choose>
								</subfield>
							</xsl:when>
							<xsl:otherwise></xsl:otherwise>
						</xsl:choose>

						<xsl:choose>
							<xsl:when test="$contributorID='A01'">
								<subfield code="c">
									<xsl:value-of select="$contributor" separator=", "/>
									<xsl:text>.</xsl:text>
								</subfield>
							</xsl:when>
							<xsl:otherwise></xsl:otherwise>									
						</xsl:choose>

					</datafield>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="subj1" match="b064">
	<xsl:param name="s"/>
		<xsl:for-each select="$s">
			<xsl:for-each select="$sh/*/code">
				<xsl:if test=".=$s">
					<datafield tag="650" ind1=" " ind2="7">
						<subfield code="a">
							<xsl:value-of select="./following-sibling::shText/text[1]"/>
						</subfield>
						<xsl:if test="./following-sibling::shText/text[2]">
						<subfield code="x">
							<xsl:value-of select="./following-sibling::shText/text[2]"/>
							<xsl:if test="not(./following-sibling::shText/text[3])">
								<xsl:text>.</xsl:text>
							</xsl:if>
						</subfield>
						</xsl:if>
						<xsl:if test="./following-sibling::shText/text[3]">
						<subfield code="x">
							<xsl:value-of select="./following-sibling::shText/text[3]"/>
							<xsl:if test="not(./following-sibling::shText/text[4])">
								<xsl:text>.</xsl:text>
							</xsl:if>
						</subfield>
						</xsl:if>
						<xsl:if test="./following-sibling::shText/text[4]">
						<subfield code="x">
							<xsl:value-of select="./following-sibling::shText/text[4]"/><xsl:text>.</xsl:text>
						</subfield>
						</xsl:if>
						<subfield code="2"><xsl:text>bisacsh</xsl:text></subfield>
					</datafield>
				</xsl:if>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="subj2" match="mainsubject/b069">
	<xsl:param name="s2"/>
		<xsl:for-each select="$s2">
			<xsl:for-each select="$sh/*/code">
				<xsl:if test=".=$s2">
					<datafield tag="650" ind1=" " ind2="7">
						<subfield code="a">
							<xsl:value-of select="./following-sibling::shText/text[1]"/>
						</subfield>
						<xsl:if test="./following-sibling::shText/text[2]">
						<subfield code="x">
							<xsl:value-of select="./following-sibling::shText/text[2]"/>
							<xsl:if test="not(./following-sibling::shText/text[3])">
								<xsl:text>.</xsl:text>
							</xsl:if>
						</subfield>
						</xsl:if>
						<xsl:if test="./following-sibling::shText/text[3]">
						<subfield code="x">
							<xsl:value-of select="./following-sibling::shText/text[3]"/>
							<xsl:if test="not(./following-sibling::shText/text[4])">
								<xsl:text>.</xsl:text>
							</xsl:if>
						</subfield>
						</xsl:if>
						<xsl:if test="./following-sibling::shText/text[4]">
						<subfield code="x">
							<xsl:value-of select="./following-sibling::shText/text[4]"/><xsl:text>.</xsl:text>
						</subfield>
						</xsl:if>
						<subfield code="2"><xsl:text>bisacsh</xsl:text></subfield>
					</datafield>
				</xsl:if>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="subj3" match="subject/b069">
	<xsl:param name="s3"/>
		<xsl:for-each select="$s3">
			<xsl:for-each select="$sh/*/code">
				<xsl:if test=".=$s3">
					<datafield tag="650" ind1=" " ind2="7">
						<subfield code="a">
							<xsl:value-of select="./following-sibling::shText/text[1]"/>
						</subfield>
						<xsl:if test="./following-sibling::shText/text[2]">
						<subfield code="x">
							<xsl:value-of select="./following-sibling::shText/text[2]"/>
							<xsl:if test="not(./following-sibling::shText/text[3])">
								<xsl:text>.</xsl:text>
							</xsl:if>
						</subfield>
						</xsl:if>
						<xsl:if test="./following-sibling::shText/text[3]">
						<subfield code="x">
							<xsl:value-of select="./following-sibling::shText/text[3]"/>
							<xsl:if test="not(./following-sibling::shText/text[4])">
								<xsl:text>.</xsl:text>
							</xsl:if>
						</subfield>
						</xsl:if>
						<xsl:if test="./following-sibling::shText/text[4]">
						<subfield code="x">
							<xsl:value-of select="./following-sibling::shText/text[4]"/><xsl:text>.</xsl:text>
						</subfield>
						</xsl:if>
						<subfield code="2"><xsl:text>bisacsh</xsl:text></subfield>
					</datafield>
				</xsl:if>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="Product">

		<record>
			<leader>
				<!-- 00-04 -->
				<xsl:text>     </xsl:text>
				<!-- 05 all ONIX records will have value n, new -->
				<xsl:text>n</xsl:text>
				<!-- 06 -->
				<xsl:text>a</xsl:text>
				<!-- 07 -->
				<xsl:text>m</xsl:text>
				<!-- 08 -->
				<xsl:text> </xsl:text>
				<!-- 09 -->
				<xsl:text> </xsl:text>
				<!-- 10 -->
				<xsl:text>2</xsl:text>
				<!-- 11 -->
				<xsl:text>2</xsl:text>
				<!-- 12-16 -->
				<xsl:text>     </xsl:text>
				<!-- 17 encodeing level; all ONIX records will have value '5', Partial (preliminary) level -->
				<xsl:text>5</xsl:text>
				<!-- 18 -->
				<xsl:text> </xsl:text>
				<!-- 19 -->
				<xsl:text> </xsl:text>
				<!-- 20-23 -->
				<xsl:text>4500</xsl:text>
			</leader>

			<!-- create 001 with dummy text and ISBN is done in another template  -->
			<xsl:for-each select="ProductIdentifier">
				<xsl:call-template name="isbn"/>
			</xsl:for-each> 

			<controlfield tag="006"><xsl:text>m\\\\</xsl:text>
			<!-- test for juvenile content with prefix of BASICMainSubject code -->
				<xsl:if test="BISACMainSubject">
				<xsl:for-each select="BISACMainSubject">
					<xsl:choose>
						<xsl:when test="substring(.,1,3)='JNF'"><xsl:text>j</xsl:text></xsl:when>
						<xsl:when test="substring(.,1,3)='JUV'"><xsl:text>j</xsl:text></xsl:when>
						<xsl:otherwise><xsl:text>\</xsl:text></xsl:otherwise>
					</xsl:choose>
					</xsl:for-each>
				</xsl:if>
				<xsl:text>o\\d\\\\\\\\</xsl:text>
			</controlfield>
			
			<controlfield tag="007"><xsl:text>cr\cn|||||||||</xsl:text></controlfield>

			<controlfield tag="008">
				<!-- 0-5 -->
				<xsl:text>      </xsl:text>
				<!-- set value for position 6 and 7-14; testing for the existence of publication date and copyright year -->
				<xsl:for-each select=".">
				<xsl:choose>
					<xsl:when test="not(PublicationDate | CopyrightYear)">
						<xsl:text>s20uu    </xsl:text>
					</xsl:when>      
					<xsl:when test="PublicationDate and CopyrightYear">t</xsl:when>
					<xsl:otherwise>s</xsl:otherwise>
				</xsl:choose>
				<xsl:choose>
					<xsl:when test="PublicationDate and CopyrightYear">
						<xsl:value-of select="substring(PublicationDate,1,4)"/>
						<xsl:value-of select="CopyrightYear"/>
					</xsl:when>
					<xsl:when test="not(PublicationDate and CopyrightYear)">
						<xsl:choose>
							<xsl:when test="PublicationDate">
								<xsl:if test="not(CopyrightYear)">
									<xsl:value-of select="substring(PublicationDate,1,4)"/><xsl:text>    </xsl:text>
								</xsl:if>
							</xsl:when>
							<xsl:when test="not(PublicationDate)">
								<xsl:if test="CopyrightYear">
									<xsl:text>    </xsl:text><xsl:value-of select="CopyrightYear"/>
								</xsl:if>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
				</xsl:choose>
				</xsl:for-each>
				<!-- 15-21 -->
				<xsl:text>xx     </xsl:text>
				<!-- 22 Audience code -->
				<xsl:choose>
					<xsl:when test="Audience">
					<xsl:for-each select="Audience[1]">
						<xsl:choose>
							<xsl:when test="AudienceCodeValue='01'">
								<xsl:text>g</xsl:text>
							</xsl:when>
							<xsl:when test="AudienceCodeValue='02'">
								<xsl:text>j</xsl:text>
							</xsl:when>
							<xsl:when test="AudienceCodeValue='03'">
								<xsl:text>d</xsl:text>
							</xsl:when>
							<xsl:when test="AudienceCodeValue='04'">
								<xsl:text>j</xsl:text>
							</xsl:when>
							<xsl:when test="AudienceCodeValue='05'">
								<xsl:text>e</xsl:text>
							</xsl:when>
							<xsl:when test="AudienceCodeValue='06'">
								<xsl:text>f</xsl:text>
							</xsl:when>
							<xsl:when test="AudienceCodeValue='07'">
								<xsl:text>f</xsl:text>
							</xsl:when>
							<xsl:when test="AudienceCodeValue='08'">
								<xsl:text>e</xsl:text>
							</xsl:when>
						</xsl:choose>
					</xsl:for-each>
					</xsl:when>
					<!-- if Audience does not exist, test for juvenile content in BISAC code -->
					<xsl:when test="not(Audience)">
						<xsl:if test="BASICMainSubject">
							<xsl:for-each select="BASICMainSubject">
								<xsl:choose>
									<xsl:when test="substring(.,1,3)='JNF'"><xsl:text>j</xsl:text></xsl:when>
									<xsl:when test="substring(.,1,3)='JUV'"><xsl:text>j</xsl:text></xsl:when>
									<xsl:otherwise><xsl:text> </xsl:text></xsl:otherwise>
								</xsl:choose>
							</xsl:for-each>
						</xsl:if>
					</xsl:when>
				</xsl:choose>
				<!-- 23 Form of item: online vs. electronic ('o' vs 's') -->
				<xsl:text>o</xsl:text>
				<!-- 24-32; 29 - Conference publication (value 0); 30 - Festschrift  (value 0); 31 – Index (value 0) -->
				<xsl:text>     000 </xsl:text>
				<!-- 33, if BISAC fiction, 1; if not fiction,0; if BISAC code missing, | - No attempte to code. -->
				<xsl:choose>
					<xsl:when test="BASICMainSubject">
						<xsl:for-each select="BASICMainSubject">
						<xsl:choose>
							<xsl:when test="substring(.,1,3)='FIC'"><xsl:text>1</xsl:text></xsl:when>
							<xsl:when test="substring(.,1,3)='JUV'"><xsl:text>1</xsl:text></xsl:when>
							<xsl:otherwise>0</xsl:otherwise>
						</xsl:choose>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise><xsl:text>|</xsl:text></xsl:otherwise>
				</xsl:choose>
				<!-- 34 biography test for BISAC codes beginning with BIO and JNF007 -->
				<xsl:choose>
					<xsl:when test="BASICMainSubject">
						<xsl:for-each select="BASICMainSubject">
						<xsl:choose>
							<xsl:when test="substring(.,1,3)='BIO'"><xsl:text>d</xsl:text></xsl:when>
							<xsl:when test="substring(.,1,6)='JNF007'"><xsl:text>d</xsl:text></xsl:when>
							<xsl:otherwise><xsl:text> </xsl:text></xsl:otherwise>
						</xsl:choose>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise><xsl:text>|</xsl:text></xsl:otherwise>
				</xsl:choose>
				<!-- 35-37 language default 'eng' not 'und' -->
				<xsl:choose>
					<xsl:when test="Language">
						<xsl:value-of select="Language/LanguageCode"/>
					</xsl:when>
					<xsl:otherwise>eng</xsl:otherwise>
				</xsl:choose>
				<!-- 38-39 -->
				<xsl:text> d</xsl:text>

			</controlfield>

			<!-- create 020 fields with both 10 and 13 digit ISBNs if they exist -->
			<xsl:for-each select="ProductIdentifier">
				<xsl:if test="./ProductIDType='02'">
					<datafield tag="020" ind1=" " ind2=" ">
						<subfield code="a">
							<xsl:value-of select="IDValue"/><xsl:text> (ebook)</xsl:text>
						</subfield>
					</datafield>
				</xsl:if>
			</xsl:for-each>

			<xsl:for-each select="ProductIdentifier">
				<xsl:if test="./ProductIDType='15'">
					<datafield tag="020" ind1=" " ind2=" ">
						<subfield code="a">
							<xsl:value-of select="IDValue"/><xsl:text> (ebook)</xsl:text>
						</subfield>
					</datafield>
				</xsl:if>
			</xsl:for-each>

			<!-- test for Language/LanguageCode other than 'eng' if so, create 041 with $a LanguageCode content -->
			<xsl:for-each select="Language">
				<xsl:choose>
					<xsl:when test="LanguageCode='spa'">
						<datafield tag="041" ind1=" " ind2=" ">
							<subfield code="a">
								<xsl:value-of select="LanguageCode"/>
							</subfield>
						</datafield>
					</xsl:when>
					<xsl:when test="LanguageCode='fre'">
						<datafield tag="041" ind1=" " ind2=" ">
							<subfield code="a">
								<xsl:value-of select="LanguageCode"/>
							</subfield>
						</datafield>
					</xsl:when>
					<xsl:when test="LanguageCode='ger'">
						<datafield tag="041" ind1=" " ind2=" ">
							<subfield code="a">
								<xsl:value-of select="b252"/>
							</subfield>
						</datafield>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>

			<!-- BASICMainSubject: The subject scheme name is now officially “BISAC”, -->
			<!-- but the ONIX data element name cannot be changed for reasons of upwards compatibility. -->			
			<xsl:for-each select="BASICMainSubject">
				<datafield tag="072" ind1=" " ind2="7">
					<subfield code="a">
						<xsl:value-of select="substring(.,1,3)"/>
					</subfield>
					<subfield code="x">
						<xsl:value-of select="substring(.,4,6)"/>
					</subfield>
					<subfield code="2">bisacsh</subfield>
				</datafield>
			</xsl:for-each>

			<!-- account for BICMainSubject -->
			<xsl:for-each select="BICMainSubject">
				<datafield tag="072" ind1=" " ind2="7">
					<subfield code="a">
						<xsl:value-of select="."/>
					</subfield>
					<subfield code="2">bicssc</subfield>
				</datafield>
			</xsl:for-each>

			<!-- the construction of 100 and 700 fields is done in another template -->			
			<xsl:for-each select="Contributor">
				<xsl:call-template name="author"/>
			</xsl:for-each>
			
			<!-- the construction of the 245 field is done in another template -->	
			<xsl:for-each select="Title[1]">
				<xsl:choose>
					<xsl:when test="following-sibling::Language/LanguageCode='spa'">
						<xsl:call-template name="Spanish2">
							<xsl:with-param name="spanish2" select="TitleText"/>
						</xsl:call-template>
					</xsl:when>
					<xsl:otherwise>
						<xsl:call-template name="title">
							<xsl:with-param name="titleString2" select="TitleText"/>
						</xsl:call-template>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>

			<xsl:choose>
			<!-- Test for the existence of EditionNumber -->
				<xsl:when test="EditionNumber">
					<xsl:for-each select="EditionNumber">
						<datafield tag="250" ind1=" " ind2=" ">
							<subfield code="a">
								<xsl:value-of select="."/>
									<xsl:choose>
										<xsl:when test=".='1'"><xsl:text>st ed.</xsl:text></xsl:when>
										<xsl:when test=".='2'"><xsl:text>nd ed.</xsl:text></xsl:when>
										<xsl:when test=".='3'"><xsl:text>rd ed.</xsl:text></xsl:when>
										<xsl:otherwise><xsl:text>th ed.</xsl:text></xsl:otherwise>
									</xsl:choose>
							</subfield>
						</datafield>
					</xsl:for-each>
				</xsl:when>
				<xsl:when test="not(EditionNumber)">
					<xsl:for-each select="EditionStatement">
						<datafield tag="250" ind1=" " ind2=" ">
							<subfield code="a">
								<xsl:value-of select="."/>
							</subfield>
						</datafield>
					</xsl:for-each>
				</xsl:when>
			</xsl:choose>

			<!-- test for the existence of Publisher element; test for PublisherRole with value of '07' to use
				 ImprintName value for constructing a second 260$b; test for existence of copyright as in 008
				 add appropriate punctuation; e.g. $c2012, c1985.  -->
			<xsl:choose>
				<xsl:when test="Publisher">
					<xsl:for-each select="Publisher">
					<xsl:variable name="copyrightDate" select="following-sibling::CopyrightYear"/>
					<xsl:variable name="imprint" select="preceding-sibling::Imprint/ImprintName"/>
						<datafield tag="260" ind1=" " ind2=" ">
							<subfield code="a">
								<xsl:choose>
									<xsl:when test="following-sibling::CityOfPublication">
										<xsl:value-of select="following-sibling::CityOfPublication"/>
										<xsl:text> :</xsl:text>
									</xsl:when>
									<xsl:otherwise>[S.l.] :</xsl:otherwise>
								</xsl:choose>
							</subfield>
					<xsl:choose>	
						<xsl:when test="PublisherName">
							<xsl:choose>
								<xsl:when test="PublishingRole='07'">
									<subfield code="b">
										<xsl:if test="$imprint">
											<xsl:value-of select="$imprint"/><xsl:text> :</xsl:text>
										</xsl:if>
									</subfield>
									<subfield code="b">
										<xsl:value-of select="PublisherName"/><xsl:text>,</xsl:text>
									</subfield>
								</xsl:when>
								<xsl:when test="not(PublishingRole='07')">
									<subfield code="b">
										<xsl:value-of select="PublisherName"/><xsl:text>,</xsl:text>
									</subfield>
								</xsl:when>
							</xsl:choose>
						</xsl:when>
						<xsl:otherwise>[S.n.],</xsl:otherwise>
					</xsl:choose>
						<subfield code="c">
							<xsl:choose>
								<xsl:when test="following-sibling::PublicationDate">
									<xsl:value-of select="substring(following-sibling::PublicationDate,1,4)"/>
										<xsl:choose>
						   					<xsl:when test="$copyrightDate">
												<xsl:text>, c</xsl:text>
													<xsl:value-of select="$copyrightDate"/>
								    			<xsl:text>.</xsl:text>
							   				</xsl:when>
							   				<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
									</xsl:when>
									<xsl:when test="not(following-sibling::PublicationDate)">
										<xsl:choose>
											<xsl:when test="$copyrightDate">
												<xsl:text>c</xsl:text>
													<xsl:value-of select="$copyrightDate"/>
												<xsl:text>.</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>[20--?]</xsl:text></xsl:otherwise>
										</xsl:choose>
									</xsl:when>
								</xsl:choose>
						</subfield>
					</datafield>
				</xsl:for-each>
			</xsl:when>

				
			<xsl:otherwise>
				<datafield tag="260" ind1=" " ind2=" ">
					<xsl:choose>
						<xsl:when test="CityOfPublication">
							<subfield code="a">
								<xsl:value-of select="CityOfPublication"/>
							</subfield>
						</xsl:when>
						<xsl:otherwise>
							<subfield code="a">[S.l.] :</subfield>
						</xsl:otherwise>
					</xsl:choose>
					<xsl:choose>
						<xsl:when test="imprint">
							<subfield code="b"><xsl:value-of select="Imprint/ImprintName"/></subfield>
						</xsl:when>
						<xsl:otherwise>
							<subfield code="b">[S.n.],</subfield>
						</xsl:otherwise>
					</xsl:choose>
							<subfield code="c">
							<xsl:choose>
							<xsl:when test="PublicationDate">
									<xsl:value-of select="substring(PublicationDate,1,4)"/>
										<xsl:choose>
							   				<xsl:when test="CopyrightYear"><xsl:text>, c</xsl:text><xsl:value-of select="CopyrightYear"/>
							    			<xsl:text>.</xsl:text>
							   				</xsl:when>
							   				<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</xsl:when>
								<xsl:otherwise>[20--?]</xsl:otherwise>
							</xsl:choose>
						</subfield>
					</datafield>
				</xsl:otherwise>
			</xsl:choose>
					
			<xsl:choose>
				<xsl:when test="NumberOfPages">
					<xsl:for-each select="NumberOfPages">
						<xsl:choose>
							<xsl:when test=". != '0'">
								<datafield tag="300" ind1=" " ind2=" ">
									<subfield code="a">1 online resource (<xsl:value-of select="."/> p.)</subfield>
								</datafield>
							</xsl:when>
							<xsl:when test=". = '0'">
								<datafield tag="300" ind1=" " ind2=" ">
									<subfield code="a">1 online resource.</subfield>
								</datafield>
							</xsl:when>
						</xsl:choose>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise>
					<datafield tag="300" ind1=" " ind2=" ">
						<subfield code="a">1 online resource.</subfield>
					</datafield>
				</xsl:otherwise>
			</xsl:choose>

		<!-- create 490/830 fields if TitleOfSeries element exists; if NumberWithinSeries exists, create subfield v -->
		<xsl:for-each select="Series">
		<xsl:variable name="series" select="TitleOfSeries"/>
			<datafield tag="490" ind1="1" ind2=" ">
				<subfield code="a">
					<xsl:value-of select="$series"/>
					<xsl:choose>
						<xsl:when test="NumberWithinSeries">
						<xsl:text>; </xsl:text>
						</xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</subfield>
				<xsl:if test="NumberWithinSeries">
				<subfield code="v">
					<xsl:value-of select="NumberWithinSeries"/>
				</subfield>
				</xsl:if>
			</datafield>
			<datafield tag="830" ind1=" " ind2="0">
				<xsl:choose>
					<xsl:when test="following-sibling::language/LanguageCode = 'spa'">
						<xsl:choose>
							<xsl:when test="substring($series,1,3)='El '">
								<subfield code="a">
									<xsl:value-of select="substring($series,4)"/>
										<xsl:choose>
											<xsl:when test="NumberWithinSeries">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="NumberWithinSeries">
								<subfield code="v">
									<xsl:value-of select="NumberWithinSeries"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
							<xsl:when test="substring($series,1,3)= 'La '">
								<subfield code="a">
									<xsl:value-of select="substring($series,4)"/>
										<xsl:choose>
											<xsl:when test="NumberWithinSeries">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="NumberWithinSeries">
								<subfield code="v">
									<xsl:value-of select="NumberWithinSeries"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
							<xsl:when test="substring($series,1,3)='Lo '">
								<subfield code="a">
									<xsl:value-of select="substring($series,4)"/>
										<xsl:choose>
											<xsl:when test="NumberWithinSeries">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="NumberWithinSeries">
								<subfield code="v">
									<xsl:value-of select="NumberWithinSeries"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
							<xsl:when test="substring($series,1,3)='Un '">
								<subfield code="a">
									<xsl:value-of select="substring($series,4)"/>
										<xsl:choose>
											<xsl:when test="NumberWithinSeries">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="NumberWithinSeries">
								<subfield code="v">
									<xsl:value-of select="NumberWithinSeries"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
							<xsl:when test="substring($series,1,4)='Las '">
								<subfield code="a">
									<xsl:value-of select="substring($series,5)"/>
										<xsl:choose>
											<xsl:when test="NumberWithinSeries">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="NumberWithinSeries">
								<subfield code="v">
									<xsl:value-of select="NumberWithinSeries"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
							<xsl:when test="substring($series,1,4)='Los ' ">
								<subfield code="a">
									<xsl:value-of select="substring($series,5)"/>
										<xsl:choose>
											<xsl:when test="NumberWithinSeries">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="NumberWithinSeries">
								<subfield code="v">
									<xsl:value-of select="NumberWithinSeries"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
							<xsl:when test="substring($series,1,4)='Una '">
								<subfield code="a">
									<xsl:value-of select="substring($series,5)"/>
										<xsl:choose>
											<xsl:when test="NumberWithinSeries">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="NumberWithinSeries">
								<subfield code="v">
									<xsl:value-of select="NumberWithinSeries"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
					<xsl:when test="not(following-sibling::language/LanguageCode='spa')">
						<xsl:choose>
							<xsl:when test="substring($series,1,2)='A '">
								<subfield code="a">
									<xsl:value-of select="substring($series,3)"/>
										<xsl:choose>
											<xsl:when test="NumberWithinSeries">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="NumberWithinSeries">
								<subfield code="v">
									<xsl:value-of select="NumberWithinSeries"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
							<xsl:when test="substring($series,1,3)='An '">
								<subfield code="a">
									<xsl:value-of select="substring($series,4)"/>
										<xsl:choose>
											<xsl:when test="NumberWithinSeries">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="NumberWithinSeries">
								<subfield code="v">
									<xsl:value-of select="NumberWithinSeries"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
							<xsl:when test="substring($series,1,4)='The '">
								<subfield code="a">
									<xsl:value-of select="substring($series,5)"/>
										<xsl:choose>
											<xsl:when test="NumberWithinSeries">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="NumberWithinSeries">
								<subfield code="v">
									<xsl:value-of select="NumberWithinSeries"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:when>
							<xsl:otherwise>
								<subfield code="a">
									<xsl:value-of select="$series"/>
										<xsl:choose>
											<xsl:when test="NumberWithinSeries">
												<xsl:text> ;</xsl:text>
											</xsl:when>
											<xsl:otherwise><xsl:text>.</xsl:text></xsl:otherwise>
										</xsl:choose>
								</subfield>
								<xsl:if test="NumberWithinSeries">
								<subfield code="v">
									<xsl:value-of select="NumberWithinSeries"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</xsl:otherwise>
						</xsl:choose>
					</xsl:when>
				</xsl:choose>
			</datafield>		
		</xsl:for-each>

		<!-- epublication type; text for value of PDF and EPUB to create 516 -->
		<xsl:if test="EpubType">
		<xsl:choose>
			<xsl:when test="EpubType/following-sibling::EpubTypeDescription">
				<datafield tag="516" ind1=" " ind2=" ">
					<subfield  code="a">
						<xsl:value-of select="EpubTypeDescription"/>
					</subfield>
				</datafield>
			</xsl:when>
			<xsl:when test="not(EpubType/following-sibling::EpubTypeDescription)">
				<datafield tag="516" ind1=" " ind2=" ">
					<subfield  code="a">
						<xsl:choose>
							<xsl:when test="EpubType eq '002'"><xsl:text>PDF</xsl:text></xsl:when>
							<xsl:when test="EpubType eq '029'"><xsl:text>EPUB</xsl:text></xsl:when>
							<!-- <xsl:when test="EpubType eq '001'"><xsl:text>HTML</xsl:text></xsl:when> -->
						</xsl:choose>
					</subfield>
				</datafield>				
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>
		</xsl:if>

		<!-- test for types of description and review quotes; create table of contents, biographical note; see List 33
			 Other Text Type Code 	-->	
		<xsl:for-each-group select="OtherText" group-by="TextTypeCode">
			<xsl:choose>
				<xsl:when test="TextTypeCode='04'">
					<xsl:choose>
						<xsl:when test="string-length(Text) &lt; 5000">
							<datafield tag="505" ind1="0" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="normalize-space(Text)"/>
								</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="string-length(Text) &gt; 5000">
							<datafield tag="505" ind1="0" ind2=" ">
								<subfield code="a"><xsl:text>FIELD LENGTH EXCEEDED</xsl:text></subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>

			<xsl:choose>
				<xsl:when test="TextTypeCode='03'">
					<xsl:choose>
						<xsl:when test="string-length(Text) &lt; 5000">
							<datafield tag="520" ind1=" " ind2=" ">
								<subfield code="a">
									<xsl:value-of select="normalize-space(current-group()[1]/Text)"/>
								</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="string-length(Text) &gt; 5000">
							<datafield tag="520" ind1=" " ind2=" ">
								<subfield code="a"><xsl:text>FIELD LENGTH EXCEEDED</xsl:text></subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>

				<xsl:when test="parent::*/child::OtherText/child::TextTypeCode= '03'"/>

				<xsl:when test="TextTypeCode = '01'">
					<xsl:choose>
						<xsl:when test="string-length(Text) &lt; 5000">
							<datafield tag="520" ind1=" " ind2=" ">
								<subfield code="a">
									<xsl:value-of select="normalize-space(current-group()[1]/Text)"/>
								</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="string-length(Text) &gt; 5000">
							<datafield tag="520" ind1=" " ind2=" ">
								<subfield code="a"><xsl:text>FIELD LENGTH EXCEEDED</xsl:text></subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
				
				<xsl:when test="parent::*/child::OtherText/child::TextTypeCode = '01'"/>

				<xsl:when test="TextTypeCode = '02'">
					<xsl:choose>
						<xsl:when test="string-length(Text) &lt; 5000">
							<datafield tag="520" ind1=" " ind2=" ">
								<subfield code="a">
									<xsl:value-of select="normalize-space(current-group()[1]/Text)"/>
								</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="string-length(Text) &gt; 5000">
							<datafield tag="520" ind1=" " ind2=" ">
								<subfield code="a"><xsl:text>FIELD LENGTH EXCEEDED</xsl:text></subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>

			<xsl:choose>
				<xsl:when test="TextTypeCode = '08'">
					<xsl:choose>
						<xsl:when test="string-length(Text) &lt; 5000">
							<datafield tag="520" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="normalize-space(current-group()[1]/Text)"/>
								</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="string-length(Text) &gt; 5000">
							<datafield tag="520" ind1="1" ind2=" ">
								<subfield code="a"><xsl:text>FIELD LENGTH EXCEEDED</xsl:text></subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>

				<xsl:when test="parent::*/child::OtherText/child::TextTypeCode = '08'"/>

				<xsl:when test="TextTypeCode='05'">
					<xsl:choose>
						<xsl:when test="string-length(Text) &lt; 5000">
							<datafield tag="520" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="normalize-space(current-group()[1]/Text)"/>
								</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="string-length(Text) &gt; 5000">
							<datafield tag="520" ind1="1" ind2=" ">
								<subfield code="a"><xsl:text>FIELD LENGTH EXCEEDED</xsl:text></subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>

				<xsl:when test="parent::*/child::OtherText/child::TextTypeCode = '05'"/>

				<xsl:when test="TextTypeCode = '07'">
					<xsl:choose>
						<xsl:when test="string-length(Text) &lt; 5000">
							<datafield tag="520" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="normalize-space(current-group()[1]/Text)"/>
								</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="string-length(Text) &gt; 5000">
							<datafield tag="520" ind1="1" ind2=" ">
								<subfield code="a"><xsl:text>FIELD LENGTH EXCEEDED</xsl:text></subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>

			<xsl:choose>
				<xsl:when test="TextTypeCode = '13'">
				<xsl:if test="not(preceding-sibling::Contributor/BiographicalNote)">
					<xsl:choose>
						<xsl:when test="string-length(Text) &lt; 5000">
							<datafield tag="545" ind1="0" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="normalize-space(current-group()[1]/Text)"/>
								</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="string-length(Text) &gt; 5000">
							<datafield tag="545" ind1="0" ind2=" ">
								<subfield code="a"><xsl:text>FIELD LENGTH EXCEEDED</xsl:text></subfield>
							</datafield>
						</xsl:when>				
					</xsl:choose>
				</xsl:if>
				</xsl:when>
			</xsl:choose>

		</xsl:for-each-group>

		<!-- audience content of $a is based on the OCLC terminology for the AudienceCode values -->
		<xsl:for-each select="AudienceCode">
			<datafield tag="521" ind1=" " ind2=" ">
				<subfield code="a">
					<xsl:choose>
						<xsl:when test=".='01'">General adult.</xsl:when>
						<xsl:when test=".='02'">Children/juvenile.</xsl:when>
						<xsl:when test=".='03'">Young adult.</xsl:when>
						<xsl:when test=".='04'">Primary and secondary school.</xsl:when>
						<xsl:when test=".='05'">College/higher education.</xsl:when>
						<xsl:when test=".='06'">Professional and scholarly.</xsl:when>
						<xsl:when test=".='07'">Intended for use in teaching English as second language.</xsl:when>
						<xsl:when test=".='08'">Adult education.</xsl:when>
					</xsl:choose>
				</subfield>
			</datafield>
		</xsl:for-each>

		<!-- if AudienceRestrictionFlag element exists, created 521 with the content of AudienceRestrictionNote element -->
		<xsl:for-each select="AudienceRestrictionNote">
			<xsl:if test="preceding-sibling::AudienceRestrictionFlag">
				<datafield tag="521" ind1=" " ind2=" ">
					<subfield code="a">
						<xsl:value-of select="normalize-space(.)"/>
					</subfield>
				</datafield>
			</xsl:if>
		</xsl:for-each>

		<!-- if BiographicalNote (b044) in the contributor composite, create 545 -->
		<xsl:for-each select="Contributor[1]/BiographicalNote">
		<xsl:if test="preceding-sibling::ContributorRole = 'A01'">
			<xsl:choose>
				<xsl:when test="string-length(.) &lt; 5000">
					<datafield tag="545" ind1="0" ind2=" ">
						<subfield code="a">
							<xsl:value-of select="normalize-space(.)"/>
						</subfield>
					</datafield>
				</xsl:when>
				<xsl:when test="string-length(.) &gt; 5000">
					<datafield tag="545" ind1="0" ind2=" ">
						<subfield code="a"><xsl:text>FIELD LENGTH EXCEEDED</xsl:text></subfield>
					</datafield>
				</xsl:when>
			</xsl:choose>
		</xsl:if>

		</xsl:for-each>

		<!-- select language if not English -->
		<xsl:for-each select="Language">
			<xsl:choose>
				<xsl:when test="LanguageCode='spa'">
					<datafield tag="546" ind1=" " ind2=" ">
						<subfield code="a">
							<xsl:text>Text in Spanish.</xsl:text>
						</subfield>
					</datafield>
				</xsl:when>
				<xsl:when test="LanguageCode='fre'">
					<datafield tag="546" ind1=" " ind2=" ">
						<subfield code="a">
							<xsl:text>Text in French.</xsl:text>
						</subfield>
					</datafield>
				</xsl:when>
				<xsl:when test="LanguageCode='ger'">
					<datafield tag="546" ind1=" " ind2=" ">
						<subfield code="a">
							<xsl:text>Text in German.</xsl:text>
						</subfield>
					</datafield>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<datafield tag="588" ind1=" " ind2=" ">
			<subfield code="a"><xsl:text>Description based on publisher data.</xsl:text></subfield>
		</datafield>

		<!-- use external XML file with subject heading text matched to codes with not found to construct 650 field for BASICMainSubject,
			MainSubject and Subject elements.  -->
		
		<xsl:if test="not(BASICMainSubject)">
			<datafield tag="650" ind1=" " ind2="7">
				<subfield code="a"><xsl:text>NoBISACMainSubjectCode</xsl:text></subfield>
			</datafield>
		</xsl:if>
		
		<xsl:for-each select="BASICMainSubject">
			<xsl:choose>
				<xsl:when test=".=$sh/*/code">
					<xsl:call-template name="subj4">
						<xsl:with-param name="s4" select="."/>
					</xsl:call-template>
				</xsl:when>
				<xsl:otherwise>
					<datafield tag="650" ind1=" " ind2="7">
						<subfield code="a"><xsl:text>NOMATCH for Bisac subject code</xsl:text><xsl:value-of select="."/></subfield>
					</datafield>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select="MainSubject">
		<xsl:variable name="t1" select="tokenize(SubjectHeadingText, '/')"/>
			<xsl:choose>
				<xsl:when test="SubjectHeadingText">
					<xsl:if test="./MainSubjectSchemeIdentifier='10'">
						<datafield tag="650" ind1=" " ind2="7">
							<subfield code="a">
								<xsl:value-of select="normalize-space($t1[1])"/>
							</subfield>
							<xsl:if test="$t1[2]">
							<subfield code="x">
								<xsl:value-of select="normalize-space($t1[2])"/>
								<xsl:if test="not($t1[3])">
									<xsl:text>.</xsl:text>
								</xsl:if>
							</subfield>
							</xsl:if>
							<xsl:if test="$t1[3]">
							<subfield code="x">
							<xsl:value-of select="normalize-space($t1[3])"/>
							<xsl:if test="not($t1[4])">
								<xsl:text>.</xsl:text>
							</xsl:if>
							</subfield>
							</xsl:if>
							<xsl:if test="$t1[4]">
							<subfield code="x">
								<xsl:value-of select="normalize-space($t1[4])"/><xsl:text>.</xsl:text>
							</subfield>
							</xsl:if>
							<subfield code="2">bisacsh</subfield>
						</datafield>
					</xsl:if>
				</xsl:when>
				<xsl:when test="not(SubjectHeadingText)">
				<xsl:if test="MainSubjectSchemeIdentifier='10'">
					<xsl:for-each select="SubjectCode">
						<xsl:choose>
							<xsl:when test=".=$sh/*/code">
								<xsl:call-template name="subj5">
									<xsl:with-param name="s5" select="."/>
								</xsl:call-template>
							</xsl:when>
							<xsl:otherwise>
								<datafield tag="650" ind1=" " ind2="7">
									<subfield code="a">
										<xsl:text>NOMATCH for subject code </xsl:text><xsl:value-of select="."/>
									</subfield>
								</datafield>
							</xsl:otherwise>
						</xsl:choose>

					</xsl:for-each>
				</xsl:if>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select="Subject">
			<xsl:variable name="t1" select="tokenize(SubjectHeadingText, '/')"/>
				<xsl:choose>
					<xsl:when test="SubjectHeadingText">
						<xsl:if test="./SubjectSchemeIdentifier='10'">
							<datafield tag="650" ind1=" " ind2="7">
								<subfield code="a">
									<xsl:value-of select="normalize-space($t1[1])"/>
								</subfield>
								<xsl:if test="$t1[2]">
								<subfield code="x">
									<xsl:value-of select="normalize-space($t1[2])"/>
									<xsl:if test="not($t1[3])">
										<xsl:text>.</xsl:text>
									</xsl:if>
								</subfield>
								</xsl:if>
								<xsl:if test="$t1[3]">
								<subfield code="x">
									<xsl:value-of select="normalize-space($t1[3])"/>
									<xsl:if test="not($t1[4])">
										<xsl:text>.</xsl:text>
									</xsl:if>
								</subfield>
								</xsl:if>
								<xsl:if test="$t1[4]">
								<subfield code="x">
									<xsl:value-of select="normalize-space($t1[4])"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="2">bisacsh</subfield>
							</datafield>
						</xsl:if>
					</xsl:when>
					<xsl:when test="not(SubjectHeadingText)">
					<xsl:if test="SubjectSchemeIdentifier='10'">
						<xsl:for-each select="SubjectCode">
							<xsl:choose>
								<xsl:when test=".=$sh/*/code">
									<xsl:call-template name="subj6">
										<xsl:with-param name="s6" select="."/>
									</xsl:call-template>
								</xsl:when>
								<xsl:otherwise>
									<datafield tag="650" ind1=" " ind2="7">
										<subfield code="a">
											<xsl:text>NOMATCH for subject code </xsl:text><xsl:value-of select="."/>
										</subfield>
									</datafield>
								</xsl:otherwise>
							</xsl:choose>
						</xsl:for-each>
					</xsl:if>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each> 

			<!-- test related product composite for RelationCode (h208) equals value of '13' (epublication based on printed product) -->
			<xsl:for-each-group select="RelatedProduct" group-by="RelationCode">
			<xsl:variable name="aut">
				<xsl:if test="parent::*/child::Contributor[1]/child::ContributorRole='A01'">
					<xsl:for-each select="parent::*/child::Contributor[1]">
					<xsl:choose>
						<xsl:when test="PersonNameInverted">
							<xsl:value-of select="PersonNameInverted"/>
						</xsl:when>
						<xsl:when test="parent::*/child::Contributor/child::PersonNameInverted"/>
						<xsl:when test="KeyNames">
							<xsl:value-of select="./KeyNames"/><xsl:text>, </xsl:text>
							<xsl:value-of select="./NamesBeforeKey"/>
						</xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:for-each>
				</xsl:if>
			</xsl:variable>

			<xsl:choose>
				<xsl:when test="RelationCode='13'">
					<datafield tag="776" ind1="0" ind2="8">
						<subfield code="i"><xsl:text>Print version: </xsl:text></subfield>
						<xsl:if test="$aut != ''">
						<subfield code="a">
							<xsl:value-of select="$aut"/><xsl:text>,</xsl:text>
						</subfield>
						</xsl:if>
						<subfield code="t">
							<xsl:value-of select="preceding-sibling::Title/TitleText"/>
						</subfield>
						<subfield code="z">
							<xsl:value-of select="current-group()[1]/ProductIdentifier/IDValue"/>
						</subfield>
					</datafield>
				</xsl:when>
				<xsl:otherwise></xsl:otherwise>
			</xsl:choose>
			</xsl:for-each-group>
			
			<!-- for Dzanc ONIX records that include a image file -->
			<xsl:for-each select="MediaFile">
				<xsl:choose>
					<xsl:when test="MediaFileLink">
						<datafield tag="856" ind1="4" ind2="2">
							<subfield code="u">
								<xsl:value-of select="MediaFileLink"/>
							</subfield>
						</datafield>
 					</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>

			<!-- for ONIX records that include a website composite element; value of '02', 
				 Publisher’s website for a specified work; value of '36', Supplier’s website for a specified work -->
			<xsl:for-each select="Website">
				<xsl:choose>
					<xsl:when test="WebsiteRole='02'">
						<datafield tag="856" ind1="4" ind2="2">
							<subfield code="y">BUY NOW</subfield>
							<subfield code="u">
								<xsl:value-of select="WebsiteLink"/>
							</subfield>
						</datafield>
					</xsl:when>
					<xsl:when test="parent::*/child::Website/child::WebsiteRole = '02'"/>
					<xsl:when test="WebsiteRole='36'">
						<datafield tag="856" ind1="4" ind2="2">
							<subfield code="y">BUY NOW</subfield>
							<subfield code="u">
								<xsl:value-of select="WebsiteLink"/>
							</subfield>
						</datafield>
					</xsl:when>
					<xsl:otherwise></xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>

		</record>
	</xsl:template>

	<!-- order of product identifier types for constructing the 001 field; use 13 digit ISBN if available;
		 if not, a 10 digit ISBN if available;  if not, publisher's or wholesaler's product number if present,
		 otherwise nothing; product identifier code: List 5 	
	<xsl:template name="isbn" match="ProductIdentifier">
   		<xsl:choose>
     		<xsl:when test="child::ProductIDType = '15'">
       			<controlfield tag="001">
		    	    <xsl:value-of select="IDValue"/>
       			</controlfield>
     		</xsl:when>
     		<xsl:when test="parent::*/child::ProductIdentifier/child::ProductIDType = '15'"/>
     		<xsl:when test="child::ProductIDType = '02'">
       			<controlfield tag="001">
         			<xsl:value-of select="IDValue"/>
       			</controlfield>
     		</xsl:when>
			<xsl:when test="parent::*/child::ProductIdentifier/child::ProductIDType = '02'"/>
     		<xsl:when test="child::ProductIDType = '01'">
       			<controlfield tag="001">
         			<xsl:value-of select="IDValue"/>
       			</controlfield>
     		</xsl:when>
     		<xsl:otherwise></xsl:otherwise>
   		</xsl:choose>
 	</xsl:template>  -->

	<!-- use publisher's or wholesaler's product number if present, if not, use 13 digit ISBN if available;
		 if not, a 10 digit ISBN; otherwise nothing; product identifier code: List 5 -->
	<xsl:template name="isbn" match="ProductIdentifier">
   		<xsl:choose>
     		<xsl:when test="child::ProductIDType = '01'">
       			<controlfield tag="001">
		    	    <xsl:value-of select="IDValue"/>
       			</controlfield>
     		</xsl:when>
     		<xsl:when test="parent::*/child::ProductIdentifier/child::ProductIDType = '01'"/>
     		<xsl:when test="child::ProductIDType = '15'">
       			<controlfield tag="001">
         			<xsl:value-of select="IDValue"/>
       			</controlfield>
     		</xsl:when>
			<xsl:when test="parent::*/child::ProductIdentifier/child::ProductIDType = '15'"/>
     		<xsl:when test="child::ProductIDType = '02'">
       			<controlfield tag="001">
         			<xsl:value-of select="IDValue"/>
       			</controlfield>
     		</xsl:when>
     		<xsl:otherwise></xsl:otherwise>
   		</xsl:choose>
 	</xsl:template> 

	<!-- test for author position to create 100 or 110 field, all others into 700 fields; test for ONIX name type varieties -->
	<xsl:template name="author" match="Contributor">
		<xsl:if test="position() =1">
		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="ContributorRole='A01'">
					<xsl:choose>
						<xsl:when test="PersonNameInverted">
							<datafield tag="100" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="PersonNameInverted"/>
									<xsl:choose>
										<xsl:when test="LettersAfterNames">
											<xsl:text>,</xsl:text>
										</xsl:when>
										<xsl:when test="not(LettersAfterNames)">
											<xsl:text>.</xsl:text>
										</xsl:when>
									</xsl:choose>
								</subfield>
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>.</xsl:text>
								</subfield>
								</xsl:if>
							</datafield>
						</xsl:when>
						<xsl:when test="parent::*/child::Contributor/child::PersonNameInverted"/>
						<xsl:when test="KeyNames">
							<datafield tag="100" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="KeyNames"/><xsl:text>, </xsl:text>
									<xsl:value-of select="NamesBeforeKey"/>
									<xsl:choose>
										<xsl:when test="SuffixToKey|LettersAfterNames">
											<xsl:text>,</xsl:text>
										</xsl:when>
										<xsl:when test="not(SuffixToKey|LetterAfterNames)">
											<xsl:text>.</xsl:text>
										</xsl:when>
									</xsl:choose>
								</subfield>
								<xsl:if test="SuffixToKey">
								<subfield code="c">
									<xsl:value-of select="SuffixToKey"/>
									<xsl:choose>
										<xsl:when test="LettersAfterNames">
											<xsl:text>,</xsl:text>
										</xsl:when>
										<xsl:when test="not(LettersAfterNames)">
											<xsl:text>.</xsl:text>
										</xsl:when>
									</xsl:choose>
								</subfield>
								</xsl:if>								
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
							</datafield>
						</xsl:when>
						<xsl:when test="parent::*/child::Contributor/child::KeyNames"/>
						<xsl:when test="CorporateName">
							<datafield tag="110" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="CorporateName"/><xsl:text>.</xsl:text>
								</subfield>
							</datafield>
						</xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		</xsl:if>

		<xsl:if test="position() gt 1">
		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="ContributorRole='A01'">
					<xsl:choose>
						<xsl:when test="PersonNameInverted">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="PersonNameInverted"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="parent::*/child::Contributor/child::PersonNameInverted"/>
						<xsl:when test="KeyNames">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="KeyNames"/><xsl:text>, </xsl:text>
									<xsl:value-of select="NamesBeforeKey"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="SuffixToKey">
								<subfield code="c">
									<xsl:value-of select="SuffixToKey"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>								
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author.</subfield>
							</datafield>
						</xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
		</xsl:if> 

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="ContributorRole='A03'">
					<xsl:choose>
						<xsl:when test="PersonNameInverted">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="PersonNameInverted"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author of screenplay.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="parent::*/child::Contributor/child::PersonNameInverted"/>
						<xsl:when test="KeyNames">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="KeyNames"/><xsl:text>, </xsl:text>
									<xsl:value-of select="NamesBeforeKey"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="SuffixToKey">
								<subfield code="c">
									<xsl:value-of select="SuffixToKey"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>								
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author of screenplay.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="ContributorRole='A12'">
					<xsl:choose>
						<xsl:when test="PersonNameInverted">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="PersonNameInverted"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">illustrator.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="parent::*/child::Contributor/child::PersonNameInverted"/>
						<xsl:when test="KeyNames">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="KeyNames"/><xsl:text>, </xsl:text>
									<xsl:value-of select="NamesBeforeKey"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="SuffixToKey">
								<subfield code="c">
									<xsl:value-of select="SuffixToKey"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>								
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">illustrator.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="ContributorRole='B01'">
					<xsl:choose>
						<xsl:when test="child::PersonNameInverted">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="PersonNameInverted"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">editor.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="parent::*/child::Contributor/child::PersonNameInverted"/>
						<xsl:when test="child::KeyNames">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="KeyNames"/><xsl:text>, </xsl:text>
									<xsl:value-of select="NamesBeforeKey"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="SuffixToKey">
								<subfield code="c">
									<xsl:value-of select="SuffixToKey"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>								
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">editor.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="b047"></xsl:when>
						<xsl:otherwise></xsl:otherwise>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="ContributorRole='B06'">
					<xsl:choose>
						<xsl:when test="PersonNameInverted">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="PersonNameInverted"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">translator.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="parent::*/child::Contributor/child::PersonNameInverted"/>
						<xsl:when test="KeyNames">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="KeyNames"/><xsl:text>, </xsl:text>
									<xsl:value-of select="NamesBeforeKey"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="SuffixToKey">
								<subfield code="c">
									<xsl:value-of select="SuffixToKey"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>								
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">translator.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="ContributorRole='B09'">
					<xsl:choose>
						<xsl:when test="PersonNameInverted">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="PersonNameInverted"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">series editor.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="parent::*/child::Contributor/child::PersonNameInverted"/>
						<xsl:when test="KeyNames">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="KeyNames"/><xsl:text>, </xsl:text>
									<xsl:value-of select="NamesBeforeKey"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="SuffixToKey">
								<subfield code="c">
									<xsl:value-of select="SuffixToKey"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>								
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">series editor.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="ContributorRole='A15'">
					<xsl:choose>
						<xsl:when test="PersonNameInverted">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="PersonNameInverted"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author of introduction, etc.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="parent::*/child::Contributor/child::PersonNameInverted"/>
						<xsl:when test="KeyNames">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="KeyNames"/><xsl:text>, </xsl:text>
									<xsl:value-of select="NamesBeforeKey"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="SuffixToKey">
								<subfield code="c">
									<xsl:value-of select="SuffixToKey"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>								
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author of introduction, etc.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="ContributorRole='A23'">
					<xsl:choose>
						<xsl:when test="PersonNameInverted">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="PersonNameInverted"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author of introduction, etc.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="parent::*/child::Contributor/child::PersonNameInverted"/>
						<xsl:when test="KeyNames">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="KeyNames"/><xsl:text>, </xsl:text>
									<xsl:value-of select="NamesBeforeKey"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="SuffixToKey">
								<subfield code="c">
									<xsl:value-of select="SuffixToKey"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>								
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author of introduction, etc.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="ContributorRole='A24'">
					<xsl:choose>
						<xsl:when test="PersonNameInverted">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="PersonNameInverted"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author of introduction, etc.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="parent::*/child::Contributor/child::PersonNameInverted"/>
						<xsl:when test="KeyNames">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="KeyNames"/><xsl:text>, </xsl:text>
									<xsl:value-of select="NamesBeforeKey"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="SuffixToKey">
								<subfield code="c">
									<xsl:value-of select="SuffixToKey"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>								
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">author of introduction, etc.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="ContributorRole='A43'">
					<xsl:choose>
						<xsl:when test="PersonNameInverted">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="PersonNameInverted"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">interviewer.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="parent::*/child::Contributor/child::PersonNameInverted"/>
						<xsl:when test="KeyNames">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="KeyNames"/><xsl:text>, </xsl:text>
									<xsl:value-of select="NamesBeforeKey"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="SuffixToKey">
								<subfield code="c">
									<xsl:value-of select="SuffixToKey"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>								
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">interviewer.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>

		<xsl:for-each select=".">
			<xsl:choose>
				<xsl:when test="ContributorRole='A44'">
					<xsl:choose>
						<xsl:when test="PersonNameInverted">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="PersonNameInverted"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">interviewee.</subfield>
							</datafield>
						</xsl:when>
						<xsl:when test="parent::*/child::Contributor/child::PersonNameInverted"/>
						<xsl:when test="KeyNames">
							<datafield tag="700" ind1="1" ind2=" ">
								<subfield code="a">
									<xsl:value-of select="KeyNames"/><xsl:text>, </xsl:text>
									<xsl:value-of select="NamesBeforeKey"/><xsl:text>,</xsl:text>
								</subfield>
								<xsl:if test="SuffixToKey">
								<subfield code="c">
									<xsl:value-of select="SuffixToKey"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>								
								<xsl:if test="LettersAfterNames">
								<subfield code="c">
									<xsl:value-of select="LettersAfterNames"/><xsl:text>,</xsl:text>
								</subfield>
								</xsl:if>
								<subfield code="e">interviewee.</subfield>
							</datafield>
						</xsl:when>
					</xsl:choose>
				</xsl:when>
			</xsl:choose>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="Spanish2" match="Title">
		<xsl:param name="spanish2"/>

		<xsl:variable name="ind1">
			<xsl:choose>
				<xsl:when test="following-sibling::Contributor[1]/ContributorRole='A01'">
					<xsl:value-of select="1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="0"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="ind2">
			<xsl:for-each select="$spanish2">
				<xsl:choose>
					<xsl:when test="substring(.,1,3)='El '">
						<xsl:value-of select="3"/>
					</xsl:when>
					<xsl:when test="substring(.,1,3)='La '">
						<xsl:value-of select="3"/>
					</xsl:when>
					<xsl:when test="substring(.,1,3)='Lo '">
						<xsl:value-of select="3"/>
					</xsl:when>
					<xsl:when test="substring(.,1,3)='Un '">
						<xsl:value-of select="3"/>
					</xsl:when>
					<xsl:when test="substring(.,1,4)='Las '">
						<xsl:value-of select="4"/>
					</xsl:when>
					<xsl:when test="substring(.,1,4)='Los '">
						<xsl:value-of select="4"/>
					</xsl:when>
					<xsl:when test="substring(.,1,4)='Una '">
						<xsl:value-of select="4"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="0"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</xsl:variable>

		<xsl:variable name="contributorID" select="following-sibling::Contributor/ContributorRole"/>

		<xsl:variable name="contributor" as="xs:string+">
			<xsl:for-each select="following-sibling::Contributor">
				<xsl:choose>
					<xsl:when test="ContributorRole='A01'">
						<xsl:choose>
							<xsl:when test="PersonName | CorporateName">
								<xsl:value-of select="PersonName | CorporateName"/>
							</xsl:when>
							<xsl:when test="parent::*/child::Contributor/child::PersonName"/>
							<xsl:when test="KeyNames">
								<xsl:choose>
									<xsl:when test="SuffixToKey">
										<xsl:value-of select="concat(NamesBeforeKey, ' ', KeyNames, ', ', SuffixToKey)"/>
									</xsl:when>
									<xsl:when test="not(SuffixToKey)">
										<xsl:value-of select="concat(NamesBeforeKey, ' ', KeyNames)"/>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
		</xsl:variable>

		<xsl:for-each select="$spanish2">
			<datafield tag="245" ind1="{$ind1}" ind2="{$ind2}">
				<subfield code="a">
					<xsl:value-of select="."/>
				</subfield>
				<subfield code="h">[electronic resource]<xsl:choose>
					<xsl:when test="following-sibling::Subtitle"><xsl:text> :</xsl:text></xsl:when>
					<xsl:when test="not(following-sibling::Subtitle)">
						<xsl:choose>
							<xsl:when test="$contributorID[1]='A01'"><xsl:text> /</xsl:text></xsl:when>
							<xsl:when test="not($contributorID[1]='A01')"><xsl:text>.</xsl:text></xsl:when>
						</xsl:choose>
					</xsl:when></xsl:choose>
				</subfield>

		<xsl:choose>
			<xsl:when test="following-sibling::Subtitle">
				<subfield code="b">
					<xsl:value-of select="following-sibling::Subtitle"/><xsl:choose>
					<xsl:when test="$contributorID[1]='A01'"><xsl:text> /</xsl:text></xsl:when>
					<xsl:otherwise>.</xsl:otherwise></xsl:choose>
				</subfield>
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>

		<xsl:choose>
			<xsl:when test="$contributorID='A01'">
				<subfield code="c">
					<xsl:value-of select="$contributor" separator=", "/>
					<xsl:text>.</xsl:text>
				</subfield>
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>									
		</xsl:choose>
			</datafield>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="title" match="Title">
		<xsl:param name="titleString2"/>

		<xsl:variable name="ind1">
			<xsl:choose>
				<xsl:when test="following-sibling::Contributor[1]/ContributorRole='A01'">
					<xsl:value-of select="1"/>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="0"/>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>

		<xsl:variable name="ind2">
			<xsl:for-each select="$titleString2">
				<xsl:choose>
					<xsl:when test="substring(.,1,2)='A '">
						<xsl:value-of select="2"/>
					</xsl:when>
					<xsl:when test="substring(.,1,3)='An '">
						<xsl:value-of select="3"/>
					</xsl:when>
					<xsl:when test="substring(.,1,4)='The '">
						<xsl:value-of select="4"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="0"/>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:for-each>
		</xsl:variable>

		<xsl:variable name="contributorID" select="following-sibling::Contributor/ContributorRole"/>

		<xsl:variable name="contributor" as="xs:string+">
			<xsl:for-each select="following-sibling::Contributor">
				<xsl:choose>
					<xsl:when test="ContributorRole='A01'">
						<xsl:choose>
							<xsl:when test="PersonName | CorporateName">
								<xsl:value-of select="PersonName | CorporateName"/>
							</xsl:when>
							<xsl:when test="parent::*/child::Contributor/child::PersonName"/>
							<xsl:when test="KeyNames">
								<xsl:choose>
									<xsl:when test="SuffixToKey">
										<xsl:value-of select="concat(NamesBeforeKey, ' ', KeyNames, ', ', SuffixToKey)"/>
									</xsl:when>
									<xsl:when test="not(SuffixToKey)">
										<xsl:value-of select="concat(NamesBeforeKey, ' ', KeyNames)"/>
									</xsl:when>
								</xsl:choose>
							</xsl:when>
						</xsl:choose>
					</xsl:when>
				</xsl:choose>
			</xsl:for-each>
		</xsl:variable>

		<xsl:for-each select="$titleString2">
			<datafield tag="245" ind1="{$ind1}" ind2="{$ind2}">
				<subfield code="a">
					<xsl:value-of select="."/>
				</subfield>
				<subfield code="h">[electronic resource]<xsl:choose>
					<xsl:when test="following-sibling::Subtitle"><xsl:text> :</xsl:text></xsl:when>
					<xsl:when test="not(following-sibling::Subtitle)">
						<xsl:choose>
							<xsl:when test="$contributorID[1]='A01'"><xsl:text> /</xsl:text></xsl:when>
							<xsl:when test="not($contributorID[1]='A01')"><xsl:text>.</xsl:text></xsl:when>
						</xsl:choose>
					</xsl:when></xsl:choose>
				</subfield>

		<xsl:choose>
			<xsl:when test="following-sibling::Subtitle">
				<subfield code="b">
					<xsl:value-of select="following-sibling::Subtitle"/><xsl:choose>
					<xsl:when test="$contributorID[1]='A01'"><xsl:text> /</xsl:text></xsl:when>
					<xsl:otherwise>.</xsl:otherwise></xsl:choose>
				</subfield>
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>
		</xsl:choose>

		<xsl:choose>
			<xsl:when test="$contributorID='A01'">
				<subfield code="c">
					<xsl:value-of select="$contributor" separator=", "/>
					<xsl:text>.</xsl:text>
				</subfield>
			</xsl:when>
			<xsl:otherwise></xsl:otherwise>									
		</xsl:choose>
			</datafield>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="subj4" match="BASICMainSubject">
	<xsl:param name="s4"/>
		<xsl:for-each select="$s4">
			<xsl:for-each select="$sh/*/code">
				<xsl:if test=".=$s4">
					<datafield tag="650" ind1=" " ind2="7">
						<subfield code="a">
							<xsl:value-of select="./following-sibling::shText/text[1]"/>
						</subfield>
						<xsl:if test="./following-sibling::shText/text[2]">
						<subfield code="x">
							<xsl:value-of select="./following-sibling::shText/text[2]"/>
							<xsl:if test="not(./following-sibling::shText/text[3])">
								<xsl:text>.</xsl:text>
							</xsl:if>
						</subfield>
						</xsl:if>
						<xsl:if test="./following-sibling::shText/text[3]">
						<subfield code="x">
							<xsl:value-of select="./following-sibling::shText/text[3]"/>
							<xsl:if test="not(./following-sibling::shText/text[4])">
								<xsl:text>.</xsl:text>
							</xsl:if>
						</subfield>
						</xsl:if>
						<xsl:if test="./following-sibling::shText/text[4]">
						<subfield code="x">
							<xsl:value-of select="./following-sibling::shText/text[4]"/><xsl:text>.</xsl:text>
						</subfield>
						</xsl:if>
						<subfield code="2"><xsl:text>bisacsh</xsl:text></subfield>
					</datafield>
				</xsl:if>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="subj5" match="MainSubject/SubjectCode">
	<xsl:param name="s5"/>
		<xsl:for-each select="$s5">
			<xsl:for-each select="$sh/*/code">
				<xsl:if test=".=$s5">
					<datafield tag="650" ind1=" " ind2="7">
						<subfield code="a">
							<xsl:value-of select="./following-sibling::shText/text[1]"/>
						</subfield>
						<xsl:if test="./following-sibling::shText/text[2]">
						<subfield code="x">
							<xsl:value-of select="./following-sibling::shText/text[2]"/>
							<xsl:if test="not(./following-sibling::shText/text[3])">
								<xsl:text>.</xsl:text>
							</xsl:if>
						</subfield>
						</xsl:if>
						<xsl:if test="./following-sibling::shText/text[3]">
						<subfield code="x">
							<xsl:value-of select="./following-sibling::shText/text[3]"/>
							<xsl:if test="not(./following-sibling::shText/text[4])">
								<xsl:text>.</xsl:text>
							</xsl:if>
						</subfield>
						</xsl:if>
						<xsl:if test="./following-sibling::shText/text[4]">
						<subfield code="x">
							<xsl:value-of select="./following-sibling::shText/text[4]"/><xsl:text>.</xsl:text>
						</subfield>
						</xsl:if>
						<subfield code="2"><xsl:text>bisacsh</xsl:text></subfield>
					</datafield>
				</xsl:if>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>

	<xsl:template name="subj6" match="Subject/SubjectCode">
	<xsl:param name="s6"/>
		<xsl:for-each select="$s6">
			<xsl:for-each select="$sh/*/code">
				<xsl:if test=".=$s6">
					<datafield tag="650" ind1=" " ind2="7">
						<subfield code="a">
							<xsl:value-of select="./following-sibling::shText/text[1]"/>
						</subfield>
						<xsl:if test="./following-sibling::shText/text[2]">
						<subfield code="x">
							<xsl:value-of select="./following-sibling::shText/text[2]"/>
							<xsl:if test="not(./following-sibling::shText/text[3])">
								<xsl:text>.</xsl:text>
							</xsl:if>
						</subfield>
						</xsl:if>
						<xsl:if test="./following-sibling::shText/text[3]">
						<subfield code="x">
							<xsl:value-of select="./following-sibling::shText/text[3]"/>
							<xsl:if test="not(./following-sibling::shText/text[4])">
								<xsl:text>.</xsl:text>
							</xsl:if>
						</subfield>
						</xsl:if>
						<xsl:if test="./following-sibling::shText/text[4]">
						<subfield code="x">
							<xsl:value-of select="./following-sibling::shText/text[4]"/><xsl:text>.</xsl:text>
						</subfield>
						</xsl:if>
						<subfield code="2"><xsl:text>bisacsh</xsl:text></subfield>
					</datafield>
				</xsl:if>
			</xsl:for-each>
		</xsl:for-each>
	</xsl:template>

</xsl:stylesheet><!-- Stylus Studio meta-information - (c) 2004-2009. Progress Software Corporation. All rights reserved.

<metaInformation>
	<scenarios>
		<scenario default="yes" name="ONIX2" userelativepaths="yes" externalpreview="no" url="..\WORKSHOP\ONIX\ShortTags\IPG_01162012_Ebooks_onix21.xml" htmlbaseurl="" outputurl="..\WORKSHOP\TRANSFORMS\testIPG.xml" processortype="saxon8" useresolver="no"
		          profilemode="0" profiledepth="" profilelength="" urlprofilexml="" commandline="" additionalpath="" additionalclasspath="" postprocessortype="none" postprocesscommandline="" postprocessadditionalpath="" postprocessgeneratedext=""
		          validateoutput="no" validator="internal" customvalidator="">
			<advancedProp name="sInitialMode" value=""/>
			<advancedProp name="bSchemaAware" value="true"/>
			<advancedProp name="bXsltOneIsOkay" value="true"/>
			<advancedProp name="bXml11" value="false"/>
			<advancedProp name="iValidation" value="0"/>
			<advancedProp name="bExtensions" value="true"/>
			<advancedProp name="iWhitespace" value="0"/>
			<advancedProp name="sInitialTemplate" value=""/>
			<advancedProp name="bTinyTree" value="true"/>
			<advancedProp name="bUseDTD" value="false"/>
			<advancedProp name="bWarnings" value="true"/>
			<advancedProp name="iErrorHandling" value="fatal"/>
		</scenario>
	</scenarios>
	<MapperMetaTag>
		<MapperInfo srcSchemaPathIsRelative="yes" srcSchemaInterpretAsXML="no" destSchemaPath="" destSchemaRoot="" destSchemaPathIsRelative="yes" destSchemaInterpretAsXML="no"/>
		<MapperBlockPosition></MapperBlockPosition>
		<TemplateContext></TemplateContext>
		<MapperFilter side="source"></MapperFilter>
	</MapperMetaTag>
</metaInformation>
-->