/*
 * Decompiled with CFR 0.152.
 */
package com.exln.stylus;

import com.exln.dxe.internal.CommandParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.util.XMLChar;
import org.apache.xml.serializer.ToXMLStream;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Import {
    Properties properties = new Properties();
    Properties initialProperties = new Properties();
    static ParamParser paramParser = null;

    public Import() {
    }

    public Import(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("The Import(properties) argument was null");
        }
        this.initialProperties = properties;
    }

    public void run(String inputFileName, String outputFileName, Properties properties, String stylesheetName) throws IOException {
        String importedFileName = null;
        if (inputFileName == null) {
            throw new IllegalArgumentException("input argument was null");
        }
        if (outputFileName == null) {
            throw new IllegalArgumentException("output argument was null");
        }
        ((Hashtable)this.properties).clear();
        ((Hashtable)this.properties).putAll(this.initialProperties);
        if (properties != null) {
            ((Hashtable)this.properties).putAll(properties);
        }
        if (stylesheetName != null) {
            String outputFileDirectoryName = outputFileName.substring(0, outputFileName.lastIndexOf("/"));
            SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS");
            importedFileName = outputFileDirectoryName + "xlnImport_" + df.format(new Date()) + ".xml";
        } else {
            importedFileName = outputFileName;
        }
        XMLReader xr = null;
        Exception handledException = null;
        ToXMLStream contentHandler = new ToXMLStream();
        contentHandler.setEncoding("utf-8");
        contentHandler.setIndent(true);
        contentHandler.setOutputStream((OutputStream)new FileOutputStream(importedFileName));
        try {
            String inputEncoding = this.properties.getProperty("com.exln.sax.inputEncoding");
            xr = this.getXMLReader((ContentHandler)contentHandler);
            InputSource inputSource = new InputSource(Import.getReader(inputFileName, inputEncoding));
            inputSource.setSystemId(inputFileName);
            xr.parse(inputSource);
        }
        catch (SAXParseException e) {
            System.err.println(((SAXException)e).toString() + " (\"" + e.getSystemId() + "\", " + "line " + e.getLineNumber() + ", " + "column " + e.getColumnNumber() + ")");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            System.exit(-1);
        }
        catch (SAXException e) {
            handledException = e;
        }
        catch (FileNotFoundException e) {
            handledException = e;
        }
        catch (IOException e) {
            handledException = e;
        }
        if (handledException != null) {
            System.err.println(handledException.toString());
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            System.exit(-1);
        }
    }

    public Document run(Reader input, Properties properties, Reader stylesheet) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("input argument was null");
        }
        return null;
    }

    public static void main(String[] args) throws IOException {
        Import.run("java com.exln.stylus.Import", args);
    }

    static void setPropertyFromOption(Properties properties, ParamParser paramParser, String option, String property) {
        if (paramParser.isOptionPresent(option)) {
            properties.setProperty(property, paramParser.getOption(option));
        }
    }

    static void setPropertyFromHexValue(Properties properties, String property, String value) {
        char[] c = new char[]{(char)Integer.parseInt(value, 16)};
        properties.setProperty(property, new String(c));
    }

    public static void run(String progName, String[] args) throws IOException {
        Vector argumentList;
        paramParser = new ParamParser(progName);
        if (!paramParser.checkArgs(args)) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            System.exit(-1);
            return;
        }
        Import imp = new Import();
        Properties properties = null;
        String inputFileName = null;
        String outputFileName = null;
        String stylesheetName = null;
        String mapArgument = null;
        Object verboseArgument = null;
        Object propertiesFileName = null;
        properties = new Properties();
        if (paramParser.isOptionPresent("S")) {
            properties.setProperty("com.exln.sax.strictXMLNames", "true");
        }
        Import.setPropertyFromOption(properties, paramParser, "c", "com.exln.sax.fixedwidth.columnWidths");
        if (paramParser.isOptionPresent("d")) {
            String delimiter = paramParser.getOption("d");
            if (delimiter.length() == 1) {
                properties.setProperty("com.exln.sax.csv.delimiter", delimiter);
            } else if (delimiter.startsWith("0x")) {
                Import.setPropertyFromHexValue(properties, "com.exln.sax.csv.delimiter", delimiter.substring(2));
            }
        }
        Import.setPropertyFromOption(properties, paramParser, "e", "com.exln.sax.inputEncoding");
        if (paramParser.isOptionPresent("H")) {
            Import.longUsage(System.out);
            System.exit(0);
        }
        if (paramParser.isOptionPresent("h")) {
            Import.shortUsage(System.out);
            System.exit(0);
        }
        if (paramParser.isOptionPresent("i")) {
            properties.setProperty("com.exln.sax.columnNamesInFile", "true");
        }
        if ((mapArgument = paramParser.getOption("m")) != null) {
            if ("child".startsWith(mapArgument)) {
                properties.setProperty("com.exln.sax.mapValuesTo", "child");
            } else if ("attribute".startsWith(mapArgument)) {
                properties.setProperty("com.exln.sax.mapValuesTo", "attribute");
            }
        }
        Import.setPropertyFromOption(properties, paramParser, "n", "com.exln.sax.columnNames");
        String columnNames = properties.getProperty("com.exln.sax.columnNames");
        if (columnNames != null) {
            StringTokenizer st = new StringTokenizer(columnNames, ",");
            while (st.hasMoreTokens()) {
                String columnName = st.nextToken();
                if (properties.getProperty("com.exln.sax.strictXMLNames") == null || XMLChar.isValidName((String)columnName)) continue;
                System.err.println("Column name \"" + columnName + "\" in \"-c\" option is not a valid " + "XML name");
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
                System.exit(-1);
            }
        }
        if (paramParser.isOptionPresent("q")) {
            String quote = paramParser.getOption("q");
            if (quote.length() == 1) {
                properties.setProperty("com.exln.sax.csv.quote", quote);
            } else if (quote.startsWith("0x")) {
                Import.setPropertyFromHexValue(properties, "com.exln.sax.csv.quote", quote.substring(2));
            }
        }
        Import.setPropertyFromOption(properties, paramParser, "R", "com.exln.sax.rootElementName");
        String rootElementName = properties.getProperty("com.exln.sax.rootElementName");
        if (rootElementName != null && properties.getProperty("com.exln.sax.strictXMLNames") != null && !XMLChar.isValidName((String)rootElementName)) {
            System.err.println("Root element name \"" + rootElementName + "\" in \"-R\" option is not a valid " + "XML name");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            System.exit(-1);
        }
        Import.setPropertyFromOption(properties, paramParser, "r", "com.exln.sax.rowElementName");
        String rowElementName = properties.getProperty("com.exln.sax.rowElementName");
        if (rowElementName != null && !XMLChar.isValidName((String)rowElementName)) {
            System.err.println("Row element name \"" + rowElementName + "\" in \"-r\" option is not a valid " + "XML name");
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            System.exit(-1);
        }
        if (paramParser.isOptionPresent("s")) {
            stylesheetName = paramParser.getOption("s");
        }
        Import.setPropertyFromOption(properties, paramParser, "t", "com.exln.sax.fixedwidth.dataTypes");
        if (paramParser.isOptionPresent("w")) {
            properties.setProperty("com.exln.sax.fixedwidth.trimWhitespace", "true");
        }
        if ((argumentList = paramParser.getArguments()).size() == 2) {
            inputFileName = (String)argumentList.elementAt(0);
            outputFileName = (String)argumentList.elementAt(1);
        }
        imp.run(inputFileName, outputFileName, properties, stylesheetName);
    }

    static void shortUsage(PrintStream out) {
        out.println(paramParser.usageDescription());
    }

    static void longUsage(PrintStream out) {
        byte[] byteArray = new byte[1];
        ByteArrayInputStream inputStream = new ByteArrayInputStream(byteArray);
        InputStreamReader reader = new InputStreamReader(inputStream);
        String defaultEncoding = reader.getEncoding();
        Import.shortUsage(out);
        out.println("\nImport a file system file of a known format into an XML document stored\nin an XMLStore. There are a number of options, discussed below, that\naffect how the mapping works.\n\n\nArguments\n\nfilename\n    Name of the disk file to be imported. This utility\n    recognizes the \"-\" as the standard input stream\n    (stdin).\n\ndocumentname\n    Name of the XML document to create in an XIS XMLStore.\n\n\nCommon Options\n\n-e encoding-string\n    The character encoding of the input text file. Values supported on all\n    platforms are: US-ASCII, ISO-8859-1, UTF-8, UTF-16BE, UTF-16LE and UTF-16.\n    The default encoding on this platform is " + defaultEncoding + ".\n" + "\n" + "-h\n" + "    Display (relatively) short usage message.\n" + "\n" + "-H\n" + "    Display complete usage message.\n" + "\n" + "-i\n" + "    The presence of this option indicates that column names will be\n" + "    found in the text file being imported. They will be in the first record read.\n" + "    This option is mutually exclusive with the -n option. If neither\n" + "    this option nor the -n option is specified, xlnimport generates\n" + "    names, one for each column in the form of value1, value2, value3,...\n" + "\n" + "-m {c[hild] | a[ttribute]}\n" + "    Indicates how column values are to be mapped into XML. If the\n" + "    argument is <code>child</code>, the column values are mapped as child elements of\n" + "    each <code>row</code> element. If you specify <code>attribute</code>, the column values are mapped\n" + "    to attributes of each <code>row</code> element. Only the first character of the\n" + "    argument needs to be specified. If this option is not specified, the\n" + "    default is <code>child</code>.\n" + "\n" + "-n list\n" + "    Comma separated list of column names. This is mutually exclusive\n" + "    with the -i option. If neither this option nor the -i option\n" + "    is specified, the import operation generate names, one for each\n" + "    column in the form of value1, value2, value3,...\n" + "\n" + "-R element-name\n" + "    Specifies the name of the root element in the resulting XML\n" + "    document. The default is \"document\".\n" + "\n" + "-r element-name\n" + "    Specifies the name of the row elements in the\n" + "    resulting XML document. The default is \"row\".\n" + "\n" + "-s stylesheetname\n" + "    Location of a stylesheet in an XMLStore. The import operation\n" + "    applies this stylesheet to the generated XML document.\n" + "    If present, the document resulting from the application of this\n" + "    stylesheet is written to the specified destination. If this\n" + "    option is not present, the generated XML document is written.\n" + "\n" + "-S\n" + "    Enforce strict XML naming rules. If there is an invalid character\n" + "    for an XML name such in a column name, the root element name or\n" + "    the row element name, an error is reported. By default these\n" + "    invalid characters are mapped to an underscore (_).\n" + "\n" + "\n" + "CSV Options\n" + "\n" + "-d c\n" + "    Character to be used as a delimiter between fields in a CSV file.\n" + "    The default for this is comma (,). The argument may be expressed as\n" + "    either a single character or in the form of 0xHHHH where HHHH is 1\n" + "    hexidecimal digits.\n" + "\n" + "-q c\n" + "    Quote character to use in a CSV file when quoting a value. For\n" + "    example one might use the single quote (') or a slash (/) character.\n" + "    By default this is a double quote (\"). The argument may be \n" + "    expressed as either a single character or in the form of 0xHHHH\n" + "    where HHHH is 1 hexidecimal digits.\n" + "\n" + "\n" + "Fixed Width Options\n" + "\n" + "-c list\n" + "    The list value is a list of character positions defining the widths\n" + "    of columns within the fixed width file being imported. This option is required\n" + "    when you are importing fixed width files.\n" + "\n" + "-t list\n" + "    Data type list for fixed width files. The list is a comma separated\n" + "    list of data type specifications. There must be one entry in this\n" + "    list for each entry in the list given for the -c option. The values\n" + "    can be either <code>string</code> or <code>number</code>. If a value is a number, then it will\n" + "    be stripped of white space and leading zeros as part of the\n" + "    transformation. The default is that all columns are strings.\n" + "\n" + "-w\n" + "   If present, this option indicates that leading and trailing\n" + "   white space is to be stripped from column values as part of the\n" + "   transformation.");
    }

    static BufferedReader getReader(String uri) throws FileNotFoundException, UnsupportedEncodingException {
        return Import.getReader(uri, null);
    }

    static BufferedReader getReader(String uri, String inputEncoding) throws FileNotFoundException, UnsupportedEncodingException {
        String fileName = null;
        boolean isXLNURI = false;
        BufferedReader br = null;
        InputStreamReader r = null;
        fileName = uri.startsWith("file:") ? uri.substring(5) : uri;
        if (!isXLNURI) {
            r = fileName.equals("-") ? (inputEncoding == null ? new InputStreamReader(System.in) : new InputStreamReader(System.in, inputEncoding)) : (inputEncoding == null ? new FileReader(fileName) : new InputStreamReader((InputStream)new FileInputStream(fileName), inputEncoding));
            br = new BufferedReader(r);
        }
        return br;
    }

    XMLReader getXMLReader(ContentHandler contentHandler) throws SAXException {
        Locator l;
        XMLReader xr = null;
        xr = this.properties.getProperty("com.exln.sax.fixedwidth.columnWidths") == null ? XMLReaderFactory.createXMLReader("com.exln.sax.CSVReader") : XMLReaderFactory.createXMLReader("com.exln.sax.FixedWidthReader");
        if (this.properties != null) {
            xr.setProperty("http://www.exln.com/sax/xlnProperties", this.properties);
        }
        if ((l = (Locator)xr.getProperty("http://www.exln.com/sax/locator")) != null) {
            contentHandler.setDocumentLocator(l);
        }
        xr.setContentHandler(contentHandler);
        return xr;
    }

    static class ParamParser
    extends CommandParser {
        public ParamParser(String progName) {
            super(progName);
        }

        public String usageDescription() {
            return this.getProgramName() + " [options] filename documentname\n" + this.getProgramName() + " -c list [options] filename documentname";
        }

        public boolean checkArgs(String[] args) {
            String mapArgument;
            String quote;
            String delimiter;
            this.defineOption("c", null, "Column widths list (Fixed Width only)");
            this.defineOption("d", ",", "Delimiter character, default \",\" (CSV only)");
            this.defineOption("e", null, "Input character encoding");
            this.defineOption("f", null, "Property file name");
            this.defineSwitch("h", "Short help message");
            this.defineSwitch("H", "Long help message");
            this.defineSwitch("i", "Column names in file");
            this.defineOption("m", null, "Map values: child or attribute, default \"child\"");
            this.defineOption("n", null, "Column name list");
            this.defineOption("q", "\"", "Quote character, default '\"' (CSV only)");
            this.defineOption("R", null, "Root element name");
            this.defineOption("r", null, "Row element name");
            this.defineOption("s", null, "Stylesheet document name");
            this.defineSwitch("S", "Strict XML names, bad characters cause an error");
            this.defineOption("t", null, "Data type list (Fixed Width only)");
            this.defineSwitch("w", "Trim whitespace (Fixed Width only)");
            if (!this.parseCommandLine(args)) {
                return false;
            }
            if (paramParser.isOptionPresent("d") && (delimiter = paramParser.getOption("d")).length() != 1) {
                if (!delimiter.startsWith("0x")) {
                    System.err.println("Delimiter argument (" + delimiter + ") must either be a single character or in the form \"0xHHHH\" where \"HHHH\" are hexidecimal digits");
                    this.usage();
                    return false;
                }
                try {
                    Integer.parseInt(delimiter.substring(2), 16);
                }
                catch (NumberFormatException e) {
                    System.err.println("Delimiter (" + delimiter + ") argument is not a hexidecimal number");
                    this.usage();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    return false;
                }
            }
            if (paramParser.isOptionPresent("q") && (quote = paramParser.getOption("q")).length() != 1) {
                if (!quote.startsWith("0x")) {
                    System.err.println("Quote argument must either be a single character or in the form \"0xHHHH\" where \"HHHH\" are hexidecimal digits");
                    this.usage();
                    return false;
                }
                try {
                    Integer.parseInt(quote.substring(2), 16);
                }
                catch (NumberFormatException e) {
                    System.err.println("Quote argument is not a hexidecimal number");
                    this.usage();
                    return false;
                }
            }
            if (this.isOptionPresent("m") && !"child".startsWith(mapArgument = this.getOption("m")) && !"attribute".startsWith(mapArgument)) {
                System.err.println("Unrecognized value for m option: " + mapArgument);
                this.usage();
                return false;
            }
            if (!this.isOptionPresent("h") && !this.isOptionPresent("H")) {
                Vector arguments = this.getArguments();
                int argCount = arguments.size();
                if (argCount < 2) {
                    System.err.println("Not enough arguments");
                    this.usage();
                    return false;
                }
                if (argCount > 2) {
                    System.err.print("Too many arguments: ");
                    int i = 0;
                    while (i < argCount - 1) {
                        System.err.print((String)arguments.elementAt(i) + ", ");
                        ++i;
                    }
                    System.err.println((String)arguments.elementAt(argCount - 1));
                    this.usage();
                    return false;
                }
            }
            return true;
        }
    }
}

