/*
 * Decompiled with CFR 0.152.
 */
package com.exln.sax;

import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.util.XMLChar;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public abstract class FlatFileReader
implements XMLReader {
    boolean columnNamesInFile = false;
    String rootElementName = "document";
    String rowElementName = "row";
    Properties properties = null;
    int delimiterLength = 0;
    boolean strictXMLNames = false;
    ContentHandler contentHandler = null;
    DTDHandler dtdHandler = null;
    EntityResolver entityResolver = null;
    ErrorHandler errorHandler = null;
    LocatorImpl locator = new LocatorImpl();
    boolean atEOF = false;
    boolean atEOL = false;
    boolean atEOR = false;
    Vector columnNames = null;
    boolean mapValuesToElements = true;
    public static final String XLN_PROPERTIES_PROPERTY = "http://www.exln.com/sax/xlnProperties";
    public static final String LOCATOR_PROPERTY = "http://www.exln.com/sax/locator";
    public static final String COLUMN_NAMES_IN_FILE_PROPERTY = "com.exln.sax.columnNamesInFile";
    public static final String COLUMN_NAMES_PROPERTY = "com.exln.sax.columnNames";
    public static final String DISCARD_RETURN_PROPERTY = "com.exln.sax.discardReturn";
    public static final String EOL_PROPERTY = "com.exln.sax.eol";
    public static final String FILE_TYPE_PROPERTY = "com.exln.sax.fileType";
    public static final String LINES_PER_RECORD_PROPERTY = "com.exln.sax.linesPerRecord";
    public static final String INPUT_ENCODING = "com.exln.sax.inputEncoding";
    public static final String MAP_VALUES_TO_PROPERTY = "com.exln.sax.mapValuesTo";
    public static final String ROOT_ELEMENT_NAME_PROPERTY = "com.exln.sax.rootElementName";
    public static final String ROW_ELEMENT_NAME_PROPERTY = "com.exln.sax.rowElementName";
    public static final String STRICT_XML_NAMES_PROPERTY = "com.exln.sax.strictXMLNames";
    static final AttributesImpl EMPTY_ATTRIBUTES_LIST = new AttributesImpl();

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public boolean getFeature(String string) {
        return false;
    }

    public Object getProperty(String string) throws SAXNotRecognizedException {
        if (string.equals(XLN_PROPERTIES_PROPERTY)) {
            return this.properties;
        }
        if (string.equals(LOCATOR_PROPERTY)) {
            return this.locator;
        }
        throw new SAXNotRecognizedException("Property '" + string + "'");
    }

    public void parse(InputSource inputSource) throws IOException, SAXException {
        Object object;
        this.locator.systemId = inputSource.getSystemId();
        FlatFileTokenizer flatFileTokenizer = null;
        String string = null;
        if (this.properties == null) {
            this.properties = new Properties();
        }
        string = this.properties.getProperty(COLUMN_NAMES_IN_FILE_PROPERTY, "false");
        this.columnNamesInFile = Boolean.valueOf(string);
        string = this.properties.getProperty(MAP_VALUES_TO_PROPERTY, "child");
        this.mapValuesToElements = string.equals("child");
        this.rootElementName = this.filterXMLName(this.properties.getProperty(ROOT_ELEMENT_NAME_PROPERTY, "document"));
        this.rowElementName = this.filterXMLName(this.properties.getProperty(ROW_ELEMENT_NAME_PROPERTY, "row"));
        string = this.properties.getProperty(STRICT_XML_NAMES_PROPERTY, "");
        this.strictXMLNames = string.equals("true");
        String string2 = this.properties.getProperty(FILE_TYPE_PROPERTY, "csv");
        AttributesImpl attributesImpl = null;
        string = this.properties.getProperty(COLUMN_NAMES_PROPERTY);
        if (string != null) {
            this.columnNames = new Vector();
            object = new StringTokenizer(string, ",");
            while (((StringTokenizer)object).hasMoreTokens()) {
                this.columnNames.add(this.filterXMLName(((StringTokenizer)object).nextToken()));
            }
        }
        flatFileTokenizer = this.tokenizerFactory(inputSource.getCharacterStream(), this.properties);
        if (this.columnNamesInFile) {
            this.locator.newline();
            this.columnNames = new Vector();
            object = null;
            do {
                object = flatFileTokenizer.nextValue();
                this.columnNames.add(this.filterXMLName((String)object));
                this.locator.columnNumber += ((String)object).length();
                if (flatFileTokenizer.atEOR()) continue;
                this.locator.columnNumber += this.delimiterLength;
            } while (!flatFileTokenizer.atEOR());
        }
        this.contentHandler.startDocument();
        this.contentHandler.startElement("", "", this.rootElementName, EMPTY_ATTRIBUTES_LIST);
        if (!this.mapValuesToElements) {
            attributesImpl = new AttributesImpl();
        }
        if (this.columnNames == null) {
            this.columnNames = new Vector();
            this.locator.newline();
            int n = 0;
            if (this.mapValuesToElements) {
                this.contentHandler.startElement("", "", this.rowElementName, EMPTY_ATTRIBUTES_LIST);
            }
            String string3 = null;
            do {
                this.columnNames.add("value" + (n + 1));
                string3 = flatFileTokenizer.nextValue();
                if (this.mapValuesToElements) {
                    this.doValueElement("", "", (String)this.columnNames.elementAt(n), EMPTY_ATTRIBUTES_LIST, string3);
                } else {
                    attributesImpl.addAttribute("", "", (String)this.columnNames.elementAt(n), "CDATA", string3);
                    this.locator.columnNumber += string3.length();
                    if (!flatFileTokenizer.atEOR()) {
                        this.locator.columnNumber += this.delimiterLength;
                    }
                }
                ++n;
            } while (!flatFileTokenizer.atEOR());
            while (n < this.columnNames.size()) {
                if (this.mapValuesToElements) {
                    this.doValueElement("", "", (String)this.columnNames.elementAt(n), EMPTY_ATTRIBUTES_LIST, "");
                } else {
                    attributesImpl.addAttribute("", "", (String)this.columnNames.elementAt(n), "CDATA", "");
                }
                ++n;
            }
            if (n != this.columnNames.size()) {
                throw new SAXParseException("Inconsistent number of columns. Expected " + this.columnNames.size() + ", found " + n + ".", this.locator);
            }
            if (!this.mapValuesToElements) {
                this.contentHandler.startElement("", "", this.rowElementName, attributesImpl);
            }
            this.contentHandler.endElement("", "", this.rowElementName);
        }
        int n = this.columnNames.size();
        while (!flatFileTokenizer.atEOF()) {
            int n2 = 0;
            if (attributesImpl != null) {
                attributesImpl.clear();
            }
            this.locator.newline();
            if (this.mapValuesToElements) {
                this.contentHandler.startElement("", "", this.rowElementName, EMPTY_ATTRIBUTES_LIST);
            }
            do {
                if (n2 >= n) {
                    throw new SAXParseException("Too many columns in record. Expected " + n + ".", this.locator);
                }
                String string4 = flatFileTokenizer.nextValue();
                if (this.mapValuesToElements) {
                    this.doValueElement("", "", (String)this.columnNames.elementAt(n2), EMPTY_ATTRIBUTES_LIST, string4);
                } else {
                    attributesImpl.addAttribute("", "", (String)this.columnNames.elementAt(n2), "CDATA", string4);
                }
                this.locator.columnNumber += string4.length();
                if (!flatFileTokenizer.atEOR()) {
                    this.locator.columnNumber += this.delimiterLength;
                }
                ++n2;
            } while (!flatFileTokenizer.atEOR() && !flatFileTokenizer.atEOF());
            while (n2 < this.columnNames.size()) {
                if (this.mapValuesToElements) {
                    this.doValueElement("", "", (String)this.columnNames.elementAt(n2), EMPTY_ATTRIBUTES_LIST, "");
                } else {
                    attributesImpl.addAttribute("", "", (String)this.columnNames.elementAt(n2), "CDATA", "");
                }
                ++n2;
            }
            if (n2 != n) {
                throw new SAXParseException("Inconsistent number of columns. Expected " + n + ", found " + n2 + ".", this.locator);
            }
            if (!this.mapValuesToElements) {
                this.contentHandler.startElement("", "", this.rowElementName, attributesImpl);
            }
            this.contentHandler.endElement("", "", this.rowElementName);
        }
        this.contentHandler.endElement("", "", this.rootElementName);
        this.contentHandler.endDocument();
    }

    public void parse(String string) {
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        this.contentHandler.setDocumentLocator(this.locator);
    }

    public void setDTDHandler(DTDHandler dTDHandler) {
        this.dtdHandler = dTDHandler;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setFeature(String string, boolean bl) {
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (!string.equals(XLN_PROPERTIES_PROPERTY)) {
            if (string.equals(LOCATOR_PROPERTY)) {
                throw new SAXNotSupportedException("Cannot set property '" + string + "'");
            }
            throw new SAXNotRecognizedException("Property '" + string + "'");
        }
        Object var3_3 = null;
        this.properties = (Properties)object;
    }

    public abstract FlatFileTokenizer tokenizerFactory(Reader var1, Properties var2) throws IOException, SAXException;

    void doValueElement(String string, String string2, String string3, Attributes attributes, String string4) throws SAXException {
        this.contentHandler.startElement(string, string2, string3, attributes);
        if (string4.length() != 0) {
            this.contentHandler.characters(string4.toCharArray(), 0, string4.length());
        }
        this.contentHandler.endElement(string, string2, string3);
    }

    String filterXMLName(String string) throws SAXException {
        int n = string.length();
        char c = '\uffff';
        StringBuffer stringBuffer = new StringBuffer(n);
        if (n > 0) {
            boolean bl = true;
            c = string.charAt(0);
            if (!XMLChar.isNameStart((int)c)) {
                bl = false;
            }
            if (this.strictXMLNames && !bl) {
                throw new SAXException("Invalid XML name: " + string);
            }
            stringBuffer.append(bl ? c : (char)'_');
            int n2 = 1;
            while (n2 < n) {
                bl = true;
                c = string.charAt(n2);
                if (!XMLChar.isName((int)c)) {
                    bl = false;
                }
                if (this.strictXMLNames && !bl) {
                    throw new SAXException("Invalid XML name: " + string);
                }
                stringBuffer.append(bl ? c : (char)'_');
                ++n2;
            }
        }
        return stringBuffer.toString();
    }

    protected abstract class FlatFileTokenizer {
        protected static final int EOL = 10;
        protected static final int EOF = -1;
        protected static final int CR = 13;
        int eol = 10;
        Reader input = null;
        int linesPerRecord = 1;
        int nextC = 13;
        Properties properties = null;
        boolean discardReturn = true;

        private FlatFileTokenizer() {
        }

        protected FlatFileTokenizer(Reader reader, Properties properties) throws IOException {
            this.input = reader;
            this.properties = properties;
            if (properties == null) {
                this.properties = new Properties();
            }
            String string = null;
            string = properties.getProperty(FlatFileReader.DISCARD_RETURN_PROPERTY, "true");
            this.discardReturn = Boolean.valueOf(string);
            string = this.properties.getProperty(FlatFileReader.EOL_PROPERTY, "\n");
            this.eol = string.charAt(0);
            string = this.properties.getProperty(FlatFileReader.LINES_PER_RECORD_PROPERTY, "1");
            this.linesPerRecord = Integer.parseInt(string);
            do {
                this.nextC = reader.read();
            } while (this.nextC == 13 && this.discardReturn);
            FlatFileReader.this.atEOF = this.nextC == -1;
        }

        protected abstract String nextValue() throws NoSuchElementException, IOException, SAXException;

        protected boolean atEOR() {
            return FlatFileReader.this.atEOR;
        }

        protected boolean atEOF() {
            return FlatFileReader.this.atEOF;
        }

        int readNextChar() throws IOException {
            int n = this.nextC;
            do {
                this.nextC = this.input.read();
            } while (this.nextC == 13 && this.discardReturn);
            return n;
        }
    }

    public class LocatorImpl
    implements Locator {
        int columnNumber = 1;
        int lineNumber = 0;
        String publicId = null;
        String systemId = null;

        public int getColumnNumber() {
            return this.columnNumber;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getPublicId() {
            return this.publicId;
        }

        public String getSystemId() {
            return this.systemId;
        }

        void newline() {
            ++this.lineNumber;
            this.columnNumber = 1;
        }
    }
}

