/*
 * Decompiled with CFR 0.152.
 */
package com.exln.sax;

import com.exln.sax.FlatFileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FixedWidthReader
extends FlatFileReader {
    public static final String COLUMN_WIDTHS_PROPERTY = "com.exln.sax.fixedwidth.columnWidths";
    public static final String DATA_TYPES_PROPERTY = "com.exln.sax.fixedwidth.dataTypes";
    public static final String TRIM_WHITESPACE_PROPERTY = "com.exln.sax.fixedwidth.trimWhitespace";

    public FlatFileReader.FlatFileTokenizer tokenizerFactory(Reader reader, Properties properties) throws IOException, SAXException {
        return new FixedWidthTokenizer(reader, properties);
    }

    class FixedWidthTokenizer
    extends FlatFileReader.FlatFileTokenizer {
        boolean discardReturn = true;
        Vector columnWidths = null;
        int currentField = 0;
        int currentLine = 1;
        int currentRecordIndex = 0;
        Vector dataTypes = new Vector();
        int fieldsPerRecord = 0;
        int lineInRecord = 1;
        StringBuffer result = new StringBuffer(200);
        boolean trimWhitespace = false;

        FixedWidthTokenizer(Reader reader, Properties properties) throws IOException, SAXException {
            super(FixedWidthReader.this, reader, properties);
            if (properties != null) {
                String string = null;
                string = properties.getProperty(FixedWidthReader.COLUMN_WIDTHS_PROPERTY);
                if (string == null) {
                    throw new SAXParseException("Attempted to parse fixed width file without specifying column widths.", FixedWidthReader.this.locator);
                }
                this.columnWidths = new Vector();
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                String string2 = null;
                while (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                    try {
                        this.columnWidths.add(new Integer(string2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SAXParseException("Exception while trying to parse '" + string2 + "' as a column width", FixedWidthReader.this.locator, numberFormatException);
                    }
                }
                string = properties.getProperty(FixedWidthReader.DATA_TYPES_PROPERTY);
                if (string != null) {
                    stringTokenizer = new StringTokenizer(string, ",");
                    string2 = null;
                    while (stringTokenizer.hasMoreTokens()) {
                        string2 = stringTokenizer.nextToken();
                        if (string2.equals("string") || string2.equals("number")) {
                            this.dataTypes.add(string2);
                            continue;
                        }
                        throw new SAXException("Invalid datatype (use 'string' or 'number'): '" + string2 + "'");
                    }
                    if (this.columnWidths.size() != this.dataTypes.size()) {
                        throw new SAXException("Column width list (size = " + this.columnWidths.size() + ") and data type list (size = " + this.dataTypes.size() + ") are different sizes.");
                    }
                } else {
                    int n = this.columnWidths.size();
                    int n2 = 0;
                    while (n2 < n) {
                        this.dataTypes.add("string");
                        ++n2;
                    }
                }
                string = properties.getProperty(FixedWidthReader.TRIM_WHITESPACE_PROPERTY, "false");
                this.trimWhitespace = string.equals("true");
            }
        }

        public String nextValue() throws NoSuchElementException, IOException, SAXException {
            if (FixedWidthReader.this.atEOF) {
                throw new NoSuchElementException();
            }
            if (FixedWidthReader.this.atEOL) {
                ++this.currentLine;
                ++this.lineInRecord;
                FixedWidthReader.this.atEOL = false;
            }
            if (FixedWidthReader.this.atEOR) {
                this.lineInRecord = 1;
                this.currentField = 0;
                FixedWidthReader.this.atEOR = false;
            }
            ++this.currentField;
            this.result.setLength(0);
            int n = (Integer)this.columnWidths.elementAt(this.currentField - 1);
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.readNextChar();
                if (n3 == this.eol) {
                    throw new SAXParseException("Unexpected end of line reached before the end of the record at line " + this.currentLine + " in field " + this.currentField, FixedWidthReader.this.locator);
                }
                this.result.append((char)n3);
                ++n2;
            }
            if (((String)this.dataTypes.elementAt(this.currentField - 1)).equals("number")) {
                double d = 0.0;
                try {
                    d = Double.parseDouble(this.result.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SAXParseException("Error parsing number", FixedWidthReader.this.locator, numberFormatException);
                }
                this.result.setLength(0);
                this.result.append(d);
            } else if (this.trimWhitespace) {
                String string = this.result.toString().trim();
                this.result.setLength(0);
                this.result.append(string);
            }
            boolean bl = FixedWidthReader.this.atEOL = this.nextC == this.eol;
            if (FixedWidthReader.this.atEOL) {
                this.readNextChar();
                FixedWidthReader.this.atEOR = this.lineInRecord == this.linesPerRecord;
            }
            FixedWidthReader.this.atEOF = FixedWidthReader.this.atEOF || this.nextC == -1;
            return this.result.toString();
        }
    }
}

