/*
 * Decompiled with CFR 0.152.
 */
package com.exln.sax;

import com.exln.sax.FlatFileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class CSVReader
extends FlatFileReader
implements XMLReader {
    public static final String ALLOW_NEW_LINES_IN_QUOTED_VALUES_PROPERTY = "com.exln.sax.csv.allowNewLinesInQuotedValues";
    public static final String DELIMITER_PROPERTY = "com.exln.sax.csv.delimiter";
    public static final String ESCAPE_STYLE_PROPERTY = "com.exln.sax.csv.escapeStyle";
    public static final String QUOTE_PROPERTY = "com.exln.sax.csv.quote";

    public CSVReader() {
        this.delimiterLength = 1;
    }

    public FlatFileReader.FlatFileTokenizer tokenizerFactory(Reader reader, Properties properties) throws IOException {
        return new CSVTokenizer(reader, properties);
    }

    class CSVTokenizer
    extends FlatFileReader.FlatFileTokenizer {
        boolean allowNewLinesInQuotedValues = false;
        int delimiter = 44;
        int escapeStyle = 1;
        int quote = 34;
        static final int QUOTE_QUOTE = 1;
        static final int SLASH_QUOTE = 2;
        static final int BEGINNING_OF_VALUE = 0;
        static final int IN_VALUE = 1;
        static final int IN_QUOTED_VALUE = 2;
        static final int QUOTE_IN_QUOTED_VALUE = 4;
        static final int END_OF_RECORD = 5;
        static final int END_OF_FILE = 6;
        static final int BACKSLASH_IN_QUOTED_VALUE = 7;
        int currentField = 0;
        int currentLine = 1;
        int lineInRecord = 1;
        StringBuffer result = new StringBuffer(200);
        int state = 0;

        CSVTokenizer(Reader reader, Properties properties) throws IOException {
            super(CSVReader.this, reader, properties);
            if (properties != null) {
                String string = null;
                string = properties.getProperty(CSVReader.ALLOW_NEW_LINES_IN_QUOTED_VALUES_PROPERTY, "false");
                this.allowNewLinesInQuotedValues = Boolean.valueOf(string);
                string = properties.getProperty(CSVReader.DELIMITER_PROPERTY, ",");
                this.delimiter = string.charAt(0);
                string = properties.getProperty(CSVReader.ESCAPE_STYLE_PROPERTY, "quote-quote");
                this.escapeStyle = string.equals("quote-quote") ? 1 : 2;
                string = properties.getProperty(CSVReader.QUOTE_PROPERTY, "\"");
                this.quote = string.charAt(0);
            }
        }

        public String nextValue() throws NoSuchElementException, IOException, SAXException {
            if (CSVReader.this.atEOF) {
                throw new NoSuchElementException();
            }
            this.result.setLength(0);
            int n = this.readNextChar();
            boolean bl = false;
            boolean bl2 = false;
            while (!bl) {
                bl2 = false;
                switch (this.state) {
                    case 0: {
                        if (CSVReader.this.atEOL) {
                            ++this.currentLine;
                            ++this.lineInRecord;
                            CSVReader.this.atEOL = false;
                        }
                        if (CSVReader.this.atEOR) {
                            this.lineInRecord = 1;
                            this.currentField = 0;
                            CSVReader.this.atEOR = false;
                        }
                        ++this.currentField;
                        if (n == this.quote) {
                            this.state = 2;
                            break;
                        }
                        this.state = 1;
                        bl2 = true;
                        break;
                    }
                    case 1: {
                        if (n == this.delimiter) {
                            this.state = 0;
                            bl = true;
                            break;
                        }
                        if (n == this.eol) {
                            CSVReader.this.atEOL = true;
                            if (this.lineInRecord == this.linesPerRecord) {
                                CSVReader.this.atEOR = true;
                            }
                            this.state = 0;
                            bl = true;
                            break;
                        }
                        if (n == -1) {
                            if (this.lineInRecord != this.linesPerRecord) {
                                throw new SAXParseException("Unexpected end of file before end of record", CSVReader.this.locator);
                            }
                            CSVReader.this.atEOF = true;
                            bl = true;
                            break;
                        }
                        this.result.append((char)n);
                        break;
                    }
                    case 2: {
                        if (this.escapeStyle == 2 && n == 92) {
                            this.state = 7;
                            break;
                        }
                        if (n == this.quote) {
                            this.state = 4;
                            break;
                        }
                        if (n == -1) {
                            throw new SAXParseException("Unexpected end of file in quoted value", CSVReader.this.locator);
                        }
                        this.result.append((char)n);
                        break;
                    }
                    case 7: {
                        if (n != this.quote) {
                            this.result.append('\\');
                        }
                        this.result.append((char)n);
                        this.state = 2;
                        break;
                    }
                    case 4: {
                        if (n == this.delimiter) {
                            this.state = 0;
                            bl = true;
                            break;
                        }
                        if (n == this.quote) {
                            this.result.append((char)n);
                            this.state = 2;
                            break;
                        }
                        if (n == this.eol) {
                            CSVReader.this.atEOL = true;
                            if (this.lineInRecord == this.linesPerRecord) {
                                CSVReader.this.atEOR = true;
                            }
                            this.state = 0;
                            bl = true;
                            break;
                        }
                        if (n == -1) {
                            if (this.lineInRecord != this.linesPerRecord) {
                                throw new SAXParseException("Unexpected end of file before end of record", CSVReader.this.locator);
                            }
                            CSVReader.this.atEOF = true;
                            bl = true;
                            break;
                        }
                        throw new SAXParseException("Unexpected character '" + String.valueOf((char)n) + "' after the quote character (" + String.valueOf((char)this.quote) + ") in a quoted string", CSVReader.this.locator);
                    }
                    default: {
                        throw new SAXException("Unknown state " + this.state + " at line " + this.currentLine + " at field " + this.currentField);
                    }
                }
                if (bl || bl2) continue;
                n = this.readNextChar();
            }
            CSVReader.this.atEOF = CSVReader.this.atEOF || this.nextC == -1;
            return this.result.toString();
        }
    }
}

