/*
 * Decompiled with CFR 0.152.
 */
package com.exln.dxe.internal;

class OptionEntry {
    private String strName = null;
    private String strDefaultValue = null;
    private String strHelp = null;
    private String strValue = null;
    private boolean bPresent = false;
    private boolean bRequired = false;
    private boolean bIsSwitch = false;

    OptionEntry(String string, String string2, String string3, boolean bl) {
        this.strName = string;
        this.strDefaultValue = string2;
        this.strHelp = string3;
        this.bPresent = false;
        this.bRequired = bl;
    }

    OptionEntry(String string, String string2) {
        this(string, null, string2, false);
        this.bIsSwitch = true;
    }

    public void reset() {
        this.strValue = "";
        this.bPresent = false;
    }

    public String getValue() {
        if (this.bIsSwitch) {
            return null;
        }
        if (this.strValue.length() == 0) {
            return this.strDefaultValue;
        }
        return this.strValue;
    }

    public void setValue(String string) {
        this.strValue = string;
        this.bPresent = true;
    }

    public boolean setValueFromTail(String string) {
        this.bPresent = true;
        int n = string.startsWith(this.strName) ? this.strName.length() : 1;
        this.strValue = string.substring(n);
        return this.strValue.length() > 0;
    }

    public boolean checkNoValue(String string) {
        this.bPresent = true;
        if (string.length() == 1) {
            return this.strName.startsWith(string);
        }
        return string.equals(this.strName);
    }

    public boolean beginningOf(String string) {
        return string.startsWith(this.strName) || string.charAt(0) == this.strName.charAt(0);
    }

    public boolean isPresent() {
        return this.bPresent;
    }

    public boolean isRequired() {
        return this.bRequired;
    }

    public boolean needsValue() {
        if (this.bIsSwitch) {
            return false;
        }
        if (this.strDefaultValue == null) {
            return true;
        }
        return this.strDefaultValue.length() > 0;
    }

    public String helpLine() {
        String string = this.strName + "\t" + this.strHelp + (this.isRequired() ? " [required]" : "");
        return string;
    }

    public void dump() {
        System.out.println("Name=" + this.strName + "\t" + "Present=" + this.bPresent + "\t" + "Required=" + this.bRequired + "\t" + "Default=" + this.strDefaultValue + "\t" + "Value=" + this.strValue + "\t" + "Help=" + this.strHelp);
    }
}

