/*
 * Decompiled with CFR 0.152.
 */
package com.exln.dxe.internal;

import com.exln.dxe.internal.OptionEntry;
import java.util.Vector;

public abstract class CommandParser {
    private Vector strArguments = new Vector();
    private Vector strDefaultArguments = new Vector();
    private Vector options = new Vector();
    private String programName = "";

    public abstract boolean checkArgs(String[] var1);

    public abstract String usageDescription();

    public CommandParser() {
    }

    protected CommandParser(String string) {
        this.programName = string;
    }

    protected String getProgramName() {
        return this.programName;
    }

    public final void setOptionalArguments(Vector vector) {
        this.strDefaultArguments = vector;
    }

    private void defineOption(String string, String string2, String string3, boolean bl) {
        OptionEntry optionEntry = new OptionEntry(string, string2, string3, bl);
        int n = this.getOptionIndex(string);
        if (n == -1) {
            this.options.addElement(optionEntry);
        } else {
            System.err.println("Error: Option defined twice or same first letter: " + string);
            this.options.setElementAt(optionEntry, n);
        }
    }

    public void defineOption(String string, String string2, String string3) {
        this.defineOption(string, string2, string3, false);
    }

    public void defineRequiredOption(String string, String string2) {
        this.defineOption(string, null, string2, true);
    }

    public void defineSwitch(String string, String string2) {
        OptionEntry optionEntry = new OptionEntry(string, string2);
        int n = this.getOptionIndex(string);
        if (n == -1) {
            this.options.addElement(optionEntry);
        } else {
            System.err.println("Error: Option defined twice or same first letter: " + string);
            this.options.setElementAt(optionEntry, n);
        }
    }

    public String getOption(String string) {
        int n = this.getOptionIndex(string);
        if (n > -1) {
            return this.Option(n).getValue();
        }
        return "";
    }

    public boolean isOptionPresent(String string) {
        int n = this.getOptionIndex(string);
        return n != -1 && this.Option(n).isPresent();
    }

    public boolean requiredArgsPresent() {
        int n = 0;
        while (n < this.options.size()) {
            if (this.Option(n).isRequired() && !this.Option(n).isPresent()) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public Vector getArguments() {
        if (this.strArguments.size() > 0) {
            return this.strArguments;
        }
        return this.strDefaultArguments;
    }

    public boolean argumentsPresent() {
        return this.strArguments.size() != 0;
    }

    public void usage() {
        System.out.println();
        System.out.println("Usage:");
        System.out.println(this.usageDescription());
        if (this.options.size() > 0) {
            System.out.println();
            System.out.println("Arguments:");
            int n = 0;
            while (n < this.options.size()) {
                System.out.println("\t" + this.Option(n).helpLine());
                ++n;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean parseCommandLine(String[] stringArray) {
        this.clear();
        int n = 0;
        while (n < stringArray.length) {
            block9: {
                block8: {
                    if (stringArray[n].charAt(0) != '-') break block8;
                    String string = stringArray[n].substring(1);
                    int n2 = this.getOptionIndex(string);
                    if (n2 <= -1) {
                        System.err.println("Error: Unknown option " + string);
                        this.usage();
                        return false;
                    }
                    if (!this.Option(n2).needsValue()) {
                        if (!this.Option(n2).checkNoValue(string)) {
                            System.err.println("Error: Option dosen't support a value: " + string);
                            this.usage();
                            return false;
                        }
                        break block9;
                    } else if (!this.Option(n2).setValueFromTail(string)) {
                        if (++n == stringArray.length) {
                            System.err.println("Error: Last option requires a value.");
                            this.usage();
                            return false;
                        }
                        this.Option(n2).setValue(stringArray[n]);
                    }
                    break block9;
                }
                this.strArguments.addElement(stringArray[n]);
            }
            ++n;
        }
        if (!this.requiredArgsPresent()) {
            System.err.println("Error: Not all required args present");
            this.usage();
            return false;
        }
        return true;
    }

    public void dump() {
        int n = 0;
        while (n < this.strArguments.size()) {
            System.out.println("Argument " + n + ": " + this.strArguments.elementAt(n));
            ++n;
        }
        int n2 = 0;
        while (n2 < this.strDefaultArguments.size()) {
            System.out.println("Default Argument " + n2 + ": " + this.strDefaultArguments.elementAt(n2));
            ++n2;
        }
        System.out.println("Options :\t" + this.options.size());
        int n3 = 0;
        while (n3 < this.options.size()) {
            this.Option(n3).dump();
            ++n3;
        }
    }

    private OptionEntry Option(int n) {
        return (OptionEntry)this.options.elementAt(n);
    }

    private int getOptionIndex(String string) {
        int n = 0;
        while (n < this.options.size()) {
            if (this.Option(n).beginningOf(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void clear() {
        int n = 0;
        while (n < this.options.size()) {
            this.Option(n).reset();
            ++n;
        }
        this.strArguments = new Vector();
    }
}

